#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_FME07.h"

static	void	Sync (void)
{
	FME07_SyncPRG(0xFF,0);
	FME07_SyncCHR(0xFF,0);
	FME07_SyncMirror();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	iNES_InitROM();
	FME07_Init(Sync);
}

CTMapperInfo	MapperInfo_069 =
{
	"Sunsoft FME-07",
	69,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	FME07_HBlank,
	NULL,
	FME07_SaveMI,
	FME07_LoadMI,
	FME07_MapperSnd,
	NULL
};