#include	"..\DLL\d_iNES.h"

static	void	PRG_Write_67CDEF (int Bank, int Where, int What)
{
	MP->SetPRG_ROM16(0x8,What);
}

static	void	PRG_Write_89AB (int Bank, int Where, int What)
{
	/* No idea */
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,PRG_Write_67CDEF);
	for (x = 0x8; x < 0xC; x++)
		MP->SetWriteHandler(x,PRG_Write_89AB);
	for (x = 0xC; x < 0xF; x++)
		MP->SetWriteHandler(x,PRG_Write_67CDEF);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	if (MP->CHR_ROM_Size) MP->SetCHR_ROM8(0,0);
	else MP->SetCHR_RAM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_071 =
{
	"Camerica (partial)",
	71,
	MS_Partial,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};