#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled;
	u16_n IRQcounter;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.IRQcounter.b0;
	MI[x++] = Mapper.IRQcounter.b1;
	MI[x++] = Mapper.IRQenabled;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.IRQcounter.b0	= MI[x++];
	Mapper.IRQcounter.b1	= MI[x++];
	Mapper.IRQenabled	= MI[x++];
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter.s0 >= (0xFFFF - 114))
		{
			Mapper.IRQenabled = 0;
			Mapper.IRQcounter.s0 = 0xFFFF;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 += 114;
	}
}

static	void	PRG_Write_89ABCDEF (int Bank, int Where, int What)
{
	What &= 0xF;	/* only 4 data lines */
	switch (Bank)
	{
	case 0x8:	Mapper.IRQcounter.n0 = What;	break;
	case 0x9:	Mapper.IRQcounter.n1 = What;	break;
	case 0xA:	Mapper.IRQcounter.n2 = What;	break;
	case 0xB:	Mapper.IRQcounter.n3 = What;	break;
	case 0xC:	Mapper.IRQenabled = What & 2;	break;
	case 0xF:	MP->SetPRG_ROM16(0x8,What);	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP->SetPRG_RAM8(0x6,0);		/* WRAM goes here */
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_RAM8(0,0);

	iNES_InitROM();

	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
}

CTMapperInfo	MapperInfo_073 =
{
	"Konami VRC3",
	73,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
