#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 CHRbanks[2];
	u8 MapData;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
	for (i = 0; i < 2; i++)	MI[x++] = Mapper.CHRbanks[i];
				MI[x++] = Mapper.MapData;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
	for (i = 0; i < 2; i++)	Mapper.CHRbanks[i]	= MI[x++];
				Mapper.MapData		= MI[x++];
}

static	void	PRG_Write_89ABCDEF (int Bank, int Where, int What)
{
	switch (Bank)
	{
	case 0x8:	MP->SetPRG_ROM8(0x8,What);	break;
	case 0x9:	MP->SetCHR_ROM4(0,Mapper.CHRbanks[0] | ((What & 2) << 3));
			MP->SetCHR_ROM4(4,Mapper.CHRbanks[1] | ((What & 4) << 2));
			Mapper.MapData = What;
			if (What & 0x01) MP->Mirror_H();
			else MP->Mirror_V();		break;
	case 0xA:	MP->SetPRG_ROM8(0xA,What);	break;
	case 0xB:					break;
	case 0xC:	MP->SetPRG_ROM8(0xA,What);	break;
	case 0xD:					break;
	case 0xE:	Mapper.CHRbanks[0] = What & 0xF;
			MP->SetCHR_ROM4(0,(What & 0xF) | ((Mapper.MapData & 2) << 3));
							break;
	case 0xF:	Mapper.CHRbanks[1] = What & 0xF;
			MP->SetCHR_ROM4(4,(What & 0xF) | ((Mapper.MapData & 4) << 2));
							break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.CHRbanks[0] = 0;
	Mapper.CHRbanks[1] = 4;
	Mapper.MapData = 0;
}

CTMapperInfo	MapperInfo_075 =
{
	"Konami VRC1",
	75,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};