#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Cmd;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Cmd = MI[x++];
}

static	void	PRG_Write_89 (int Bank, int Where, int What)
{
	switch (Where & 0x001)
	{
	case 0:	Mapper.Cmd = What;			break;
	case 1:	switch (Mapper.Cmd & 0x07)
		{
		case 2:	MP->SetCHR_ROM2(0,What);	break;
		case 3:	MP->SetCHR_ROM2(2,What);	break;
		case 4:	MP->SetCHR_ROM2(4,What);	break;
		case 5:	MP->SetCHR_ROM2(6,What);	break;
		case 6:	if (Mapper.Cmd & 0x40)
				MP->SetPRG_ROM8(0xC,What);
			else	MP->SetPRG_ROM8(0x8,What);
							break;
		case 7:	MP->SetPRG_ROM8(0xA,What);	break;
		}				break;
	}
}

static	void	PRG_Write_AB (int Bank, int Where, int What)
{
	switch (Where & 0x001)
	{
	case 0:	if (What & 0x01)
			MP->Mirror_H();
		else	MP->Mirror_V();		break;
	case 1:					break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_89);
	MP->SetWriteHandler(0x9,PRG_Write_89);
	MP->SetWriteHandler(0xA,PRG_Write_AB);
	MP->SetWriteHandler(0xB,PRG_Write_AB);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);

	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.Cmd = 0;
}

CTMapperInfo	MapperInfo_076 =
{
	"Mapper 76",
	76,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};