#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,_74xx.Data & 0x7);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM8(0,(_74xx.Data & 0xF0) >> 4);
	if (_74xx.Data & 0x8)
		((MP->Flags & 0x08) ? MP->Mirror_V() : MP->Mirror_S1());
	else	((MP->Flags & 0x08) ? MP->Mirror_H() : MP->Mirror_S0());
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_078 =
{
	"Irem 74HC161/32",
	78,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};
