#include	"..\DLL\d_iNES.h"

static	struct
{
	PWriteFunc PRG_Write_4;
}	Mapper;

static	void	PRG_Write_45 (int Bank, int Where, int What)
{
	if (Where & 0x100)
	{
		MP->SetCHR_ROM8(0,What & 0x7);
		MP->SetPRG_ROM32(0x8,(What & 0x8) >> 3);
	}
	if (Bank == 4) Mapper.PRG_Write_4(Bank,Where,What);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	Mapper.PRG_Write_4 = MP->GetWriteHandler(0x4);

	for (x = 0x4; x <= 0x5; x++)
		MP->SetWriteHandler(x,PRG_Write_45);

	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_079 =
{
	"NINA-03/NINA-06",
	79,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
