#include	"..\DLL\d_iNES.h"

static	void	PRG_Write_67 (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	switch (Loc)
	{
	case 0x7EF0:	MP->SetCHR_ROM2(0,What >> 1);	break;
	case 0x7EF1:	MP->SetCHR_ROM2(2,What >> 1);	break;
	case 0x7EF2:	MP->SetCHR_ROM1(4,What);	break;
	case 0x7EF3:	MP->SetCHR_ROM1(5,What);	break;
	case 0x7EF4:	MP->SetCHR_ROM1(6,What);	break;
	case 0x7EF5:	MP->SetCHR_ROM1(7,What);	break;
	case 0x7EF6:	if (What & 1)
				MP->Mirror_H();
			else	MP->Mirror_V();		break;
	case 0x7EFA:
	case 0x7EFB:	MP->SetPRG_ROM8(0x8,What);	break;
	case 0x7EFC:
	case 0x7EFD:	MP->SetPRG_ROM8(0xA,What);	break;
	case 0x7EFE:
	case 0x7EFF:	MP->SetPRG_ROM8(0xC,What);	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x6,PRG_Write_67);
	MP->SetWriteHandler(0x7,PRG_Write_67);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM8(0,0);
	
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_080 =
{
	"Mapper 80",
	80,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};