#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\Sound\s_VRC7.h"

static	struct
{
	u8 IRQenabled, IRQtoggle, IRQlatch, IRQcounter;
	u8 sndreg;
	u8 PRG[3], CHR[8], Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM8(0x8,Mapper.PRG[0]);
	MP->SetPRG_ROM8(0xA,Mapper.PRG[1]);
	MP->SetPRG_ROM8(0xC,Mapper.PRG[2]);
	MP->SetPRG_ROM8(0xE,-1);
	if (MP->CHR_ROM_Size)
	{
		for (x = 0; x < 8; x++)
			MP->SetCHR_ROM1(x,Mapper.CHR[x]);
	}
	else
	{
		for (x = 0; x < 8; x++)
			MP->SetCHR_RAM1(x,Mapper.CHR[x] & 7);
	}
	switch (Mapper.Mirror & 0x3)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.IRQtoggle;
			MI[x++] = Mapper.IRQlatch;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.sndreg;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
for (i = 0; i < 8; i++)	MI[x++] = VRC7sound.Instrument[0][i];
for (i = 0; i < 6; i++)	MI[x++] = VRC7sound.Chan1x[i];
for (i = 0; i < 6; i++)	MI[x++] = VRC7sound.Chan2x[i];
for (i = 0; i < 6; i++)	MI[x++] = VRC7sound.Chan3x[i];
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQenabled		= MI[x++];
			Mapper.IRQtoggle		= MI[x++];
			Mapper.IRQlatch			= MI[x++];
			Mapper.IRQcounter		= MI[x++];
			Mapper.sndreg			= MI[x++];
for (i = 0; i < 3; i++)	Mapper.PRG[i]			= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]			= MI[x++];
			Mapper.sndreg			= MI[x++];

for (i = 0; i < 8; i++)	VRC7sound.Instrument[0][i]	= MI[x++];
for (i = 0; i < 6; i++)	VRC7sound.Chan1x[i]		= MI[x++];
for (i = 0; i < 6; i++)	VRC7sound.Chan2x[i]		= MI[x++];
for (i = 0; i < 6; i++)	VRC7sound.Chan3x[i]		= MI[x++];

for (x = 0; x < 6; x++){VRC7_LoadInstrument(x);
			VRC7_SoundWrite((u8)(0x10 + x),VRC7sound.Chan1x[x]);}
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter == 0xFF)
		{
			Mapper.IRQcounter = Mapper.IRQlatch;
			MP->IRQ();
		}
		else	Mapper.IRQcounter++;
	}
}

static	void	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	Loc |= (Loc & 0x8) << 1;
	switch (Loc & 0xF030)
	{
	case 0x8000:	case 0x8020:	Mapper.PRG[0] = What;	break;
	case 0x8010:	case 0x8030:	Mapper.PRG[1] = What;	break;
	case 0x9000:	case 0x9020:	Mapper.PRG[2] = What;	break;
	case 0x9010:	Mapper.sndreg = What;			break;
	case 0x9030:	VRC7_SoundWrite(Mapper.sndreg,(u8)What);break;
	case 0xA000:	case 0xA020:	Mapper.CHR[0] = What;	break;
	case 0xA010:	case 0xA030:	Mapper.CHR[1] = What;	break;
	case 0xB000:	case 0xB020:	Mapper.CHR[2] = What;	break;
	case 0xB010:	case 0xB030:	Mapper.CHR[3] = What;	break;
	case 0xC000:	case 0xC020:	Mapper.CHR[4] = What;	break;
	case 0xC010:	case 0xC030:	Mapper.CHR[5] = What;	break;
	case 0xD000:	case 0xD020:	Mapper.CHR[6] = What;	break;
	case 0xD010:	case 0xD030:	Mapper.CHR[7] = What;	break;
	case 0xE000:	case 0xE020:	Mapper.Mirror = What;	break;
	case 0xE010:	case 0xE030:	Mapper.IRQlatch = What;	break;
	case 0xF000:	case 0xF020:	Mapper.IRQtoggle = What & 0x1;
					Mapper.IRQenabled = What & 0x2;
					if (Mapper.IRQenabled)
						Mapper.IRQcounter = Mapper.IRQlatch;
								break;
	case 0xF010:	case 0xF030:	Mapper.IRQenabled = Mapper.IRQtoggle;
								break;
	}
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
	KillOPL2();
}

static	void	MapperSnd (s16 *Buffer, int Len)
{
	GetVRC7Snd(Buffer,Len);
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	Mapper.sndreg = 0;
	CreateOPL2();

	iNES_InitROM();
	Mapper.IRQenabled = Mapper.IRQtoggle = Mapper.IRQlatch = Mapper.IRQcounter = 0;
	Mapper.PRG[0] = 0x00;	Mapper.PRG[0] = 0x01;	Mapper.PRG[2] = 0xFE;
	for (x = 0; x < 8; x++)	Mapper.CHR[x] = x;
	Sync();
}

CTMapperInfo	MapperInfo_085 =
{
	"Konami VRC7",
	85,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	MapperSnd,
	NULL
};