#include	"..\DLL\d_iNES.h"

static	void	PRG_Write_67 (int Bank, int Where, int What)
{
	MP->SetCHR_ROM8(0,(What & 0x02) >> 1);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x6,PRG_Write_67);
	MP->SetWriteHandler(0x7,PRG_Write_67);

	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_087 =
{
	"Mapper 87",
	87,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
