#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 Mul1, Mul2, BankMode, BankPage;
	u8 PRGbanks[4];
	u16_n CHRbanks[8];
	u16_n Nametables[4];
	u8 Mirror;
}	Mapper;

static	void	SyncPRG (void)
{
	switch (Mapper.BankMode & 0x3)
	{
	case 0:	MP->SetPRG_ROM32(0x8,-1);	break;
	case 1:	MP->SetPRG_ROM16(0x8,((Mapper.BankPage << 5) & 0xC0) | Mapper.PRGbanks[1] << 1);
		MP->SetPRG_ROM16(0xC,-1);	break;
	case 2:

		MP->SetPRG_ROM8(0x8,((Mapper.BankPage << 5) & 0xC0) | Mapper.PRGbanks[0]);
		MP->SetPRG_ROM8(0xA,((Mapper.BankPage << 5) & 0xC0) | Mapper.PRGbanks[1]);
		MP->SetPRG_ROM8(0xC,((Mapper.BankPage << 5) & 0xC0) | Mapper.PRGbanks[2]);
		if (Mapper.BankMode & 0x04)
			MP->SetPRG_ROM8(0xE,((Mapper.BankPage << 5) & 0xC0) | Mapper.PRGbanks[3]);
		else
		{
			MP->SetPRG_ROM8(0xE,-1);
			if (Mapper.BankMode & 0x80)
				MP->SetPRG_ROM8(0x6,((Mapper.BankPage << 5) & 0xC0) | Mapper.PRGbanks[3]);
		}				break;
	case 3:	MP->DbgOut("Mapper 90: PRG mode 8kb reverse?");
						break;
	}
}

static	void	SyncCHR (void)
{
	switch ((Mapper.BankMode & 0x18) >> 3)
	{
	case 0:	MP->SetCHR_ROM8(0,Mapper.CHRbanks[0].s0);	break;
	case 1:	MP->SetCHR_ROM4(0,Mapper.CHRbanks[0].s0);
		MP->SetCHR_ROM4(4,Mapper.CHRbanks[4].s0);	break;
	case 2:	MP->SetCHR_ROM2(0,Mapper.CHRbanks[0].s0);
		MP->SetCHR_ROM2(2,Mapper.CHRbanks[2].s0);
		MP->SetCHR_ROM2(4,Mapper.CHRbanks[4].s0);
		MP->SetCHR_ROM2(6,Mapper.CHRbanks[6].s0);	break;
	case 3:	MP->SetCHR_ROM1(0,Mapper.CHRbanks[0].s0);
		MP->SetCHR_ROM1(1,Mapper.CHRbanks[1].s0);
		MP->SetCHR_ROM1(2,Mapper.CHRbanks[2].s0);
		MP->SetCHR_ROM1(3,Mapper.CHRbanks[3].s0);
		MP->SetCHR_ROM1(4,Mapper.CHRbanks[4].s0);
		MP->SetCHR_ROM1(5,Mapper.CHRbanks[5].s0);
		MP->SetCHR_ROM1(6,Mapper.CHRbanks[6].s0);
		MP->SetCHR_ROM1(7,Mapper.CHRbanks[7].s0);	break;
	}
}

static	void	SyncNametables (void)
{
	switch (Mapper.Mirror)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
	if (Mapper.BankMode & 0x20)
	{
		if (Mapper.Nametables[0].s0 & 0x80) MP->SetCHR_ROM8(0x8,Mapper.Nametables[0].s0);
		if (Mapper.Nametables[1].s0 & 0x80) MP->SetCHR_ROM8(0x9,Mapper.Nametables[1].s0);
		if (Mapper.Nametables[2].s0 & 0x80) MP->SetCHR_ROM8(0xA,Mapper.Nametables[2].s0);
		if (Mapper.Nametables[3].s0 & 0x80) MP->SetCHR_ROM8(0xB,Mapper.Nametables[3].s0);
	}
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.Mul1;
			MI[x++] = Mapper.Mul2;
			MI[x++] = Mapper.BankMode;
			MI[x++] = Mapper.BankPage;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.IRQcounter;
			MI[x++] = Mapper.IRQlatch;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRGbanks[i];
for (i = 0; i < 8; i++){MI[x++] = Mapper.CHRbanks[i].b0;
			MI[x++] = Mapper.CHRbanks[i].b1;}
for (i = 0; i < 4; i++){MI[x++] = Mapper.Nametables[i].b0;
			MI[x++] = Mapper.Nametables[i].b1;}
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.Mul1		= MI[x++];
			Mapper.Mul2		= MI[x++];
			Mapper.BankMode		= MI[x++];
			Mapper.BankPage		= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.IRQcounter	= MI[x++];
			Mapper.IRQlatch		= MI[x++];
for (i = 0; i < 4; i++)	Mapper.PRGbanks[i]	= MI[x++];
for (i = 0; i < 8; i++){Mapper.CHRbanks[i].b0	= MI[x++];
			Mapper.CHRbanks[i].b1	= MI[x++];}
for (i = 0; i < 4; i++){Mapper.Nametables[i].b0	= MI[x++];
			Mapper.Nametables[i].b1	= MI[x++];}
	SyncNametables();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if ((Scanline < 0) || (Scanline > 240)) return;
	if ((Mapper.IRQenabled) && (Byte2001 & 0x18))
	{
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQlatch = 0;
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
		else Mapper.IRQcounter--;
	}
}

static	int	PRG_Read_5 (int Bank, int Where)
{
	switch (Where)
	{
	case 0x000:	return (((Mapper.Mul1 * Mapper.Mul2) & 0x00FF) >> 0);	break;
//	case 0x001:	return (((Mapper.Mul1 * Mapper.Mul2) & 0xFF00) >> 8);	break;
	}
	return Where & 0xFF;
}

static	void	PRG_Write_5 (int Bank, int Where, int What)
{
	switch (Where)
	{
	case 0x000:	Mapper.Mul1 = What;	break;
	case 0x001:	Mapper.Mul2 = What;	break;
	}
}

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	if (Where > 7)
		return;
	Mapper.PRGbanks[Where & 3] = What;
	SyncPRG();
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	if (Where > 7)
		return;
	Mapper.CHRbanks[Where & 7].b0 = What;
	SyncCHR();
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	if (Where > 7)
		return;
	Mapper.CHRbanks[Where & 7].b1 = What;
	SyncPRG();
}

static	void	PRG_Write_B (int Bank, int Where, int What)
{
	if (Where > 7)
		return;
	if (Where & 4)
		Mapper.Nametables[Where & 3].b1 = What;
	else	Mapper.Nametables[Where & 3].b0 = What;
	SyncNametables();
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	switch (Where/* & 0x07*/)
	{
	case 0:	case 4:	Mapper.IRQlatch = What;			break;
	case 1:	case 5:	Mapper.IRQcounter = What;		break;
	case 2:	case 6:	Mapper.IRQenabled = 0;
			Mapper.IRQcounter = Mapper.IRQlatch;	break;
	case 3:	case 7:	Mapper.IRQenabled = 1;			break;

	
///*	case 0:
//	case 1:
//	case 6:
//	case 7:						break;*/
//
//	case 2:	Mapper.IRQenabled = 0;			break;
//	case 3:
//	case 4:	if (Mapper.IRQenabled == 0)
//		{
//			Mapper.IRQenabled = 1;
//			Mapper.IRQcounter = Mapper.IRQlatch;
//		}					break;
//	case 5:	Mapper.IRQcounter = What;
//		Mapper.IRQlatch = What;			break;
	}
}

static	void	PRG_Write_D (int Bank, int Where, int What)
{
	switch (Where/* & 0x07*/)
	{
	case 0:	Mapper.BankMode = What;
		SyncPRG();
		SyncCHR();
		SyncNametables();	break;
	case 1:	Mapper.Mirror = What & 3;
		SyncNametables();	break;
	case 2:				break;
	case 3:	Mapper.BankPage = What;
		SyncPRG();
		SyncCHR();
		SyncNametables();	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetReadHandler(0x5,PRG_Read_5);
	MP->SetWriteHandler(0x5,PRG_Write_5);
	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xB,PRG_Write_B);
	MP->SetWriteHandler(0xC,PRG_Write_C);
	MP->SetWriteHandler(0xD,PRG_Write_D);

	MP->SetPRG_ROM32(0x8,-1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.IRQenabled = Mapper.IRQcounter = Mapper.IRQlatch = 0;
	Mapper.Mul1 = Mapper.Mul2 = 0;
	Mapper.BankMode = Mapper.BankPage = 0;
	Mapper.PRGbanks[0] = MP->GetPRG_ROM8(0x8);
	Mapper.PRGbanks[1] = MP->GetPRG_ROM8(0xA);
	Mapper.PRGbanks[2] = MP->GetPRG_ROM8(0xC);
	Mapper.PRGbanks[3] = MP->GetPRG_ROM8(0xE);
	for (x = 0; x < 8; x++)	Mapper.CHRbanks[x].s0 = x;
	for (x = 0; x < 4; x++)	Mapper.Nametables[x].s0 = 0;
	Mapper.Mirror = 0;
}

CTMapperInfo	MapperInfo_090 =
{
	"PC-JY-??",
	90,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};