#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[4];
	u8 CHR[4];
	u8 IRQcounter;
	u8 IRQenabled;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
	{
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x]);
		MP->SetCHR_ROM2(0 | (x << 1),Mapper.CHR[x]);
	}
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
for (i = 0; i < 4; i++)	MI[x++] = Mapper.CHR[i];
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	Mapper.PRG[i]	= MI[x++];
for (i = 0; i < 4; i++)	Mapper.CHR[i]	= MI[x++];
	Sync();
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if ((Scanline < 0) || (Scanline > 240))
		return;
	if ((Mapper.IRQenabled) && (Byte2001 & 0x18))
	{
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter--;
	}
}

static	void	Write (int Bank, int Where, int What)
{
	switch (Bank)
	{
	case 0x6:	Mapper.CHR[Where & 3] = What;	break;
	case 0x7:	switch (Where & 3)
			{
			case 0:
			case 1:	Mapper.PRG[Where & 3] = What;	break;
			case 2:	Mapper.IRQcounter = What;	break;
			case 3:	Mapper.IRQenabled = What;	break;
			}				break;
	}
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	for (x = 0x6; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);

	iNES_InitROM();

	for (x = 0; x < 4; x++)
		Mapper.CHR[x] = 0;

	Mapper.PRG[0] = Mapper.PRG[2] = 0xFE;
	Mapper.PRG[1] = Mapper.PRG[3] = 0xFF;

	Sync();
}

CTMapperInfo	MapperInfo_091 =
{
	"PC-HK-SF3",
	91,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};