#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,(_74xx.Data & 0xF0) >> 4);
	MP->SetPRG_ROM16(0xC,-1);
	if (MP->CHR_ROM_Size)
		MP->SetCHR_ROM8(0,0);
	else	MP->SetCHR_RAM8(0,0);
	if (_74xx.Data & 0x01) MP->Mirror_H();
	else MP->Mirror_V();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_093 =
{
	"Mapper 93",
	93,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};