#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,(_74xx.Data >> 2) & 0x7);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_RAM8(0,0);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_094 =
{
	"Mapper 94",
	94,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};