#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,-1);
	MP->SetPRG_ROM16(0xC,_74xx.Data & 0xF);
	MP->SetCHR_RAM8(0,0);
	switch ((_74xx.Data >> 6) & 0x3)
	{
	case 0:	/* MP->Mirror_S0();
		/* uncertain */		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_V();		break;
	case 3:	/* MP->Mirror_S1();
		/* uncertain */		break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_097 =
{
	"Kid Niki (J)",
	97,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};
