#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_VS.h"

static	struct
{
	PWriteFunc Write;
	u8 CHR;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_RAM8(0x6,0);
	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_ROM8(0,Mapper.CHR);
}

static	void	Write (int Bank,int Where,int What)
{
	if (Where == 0x016)
	{
		Mapper.CHR = (What & 0x04) >> 2;
		Sync();
	}
	Mapper.Write(Bank,Where,What);
}

static	void	HBlank (int Scanline, int Byte2001)
{
	VS_CheckCoin(Scanline);
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	Mapper.Write = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,Write);
	Mapper.CHR = 0;
	Sync();
	iNES_InitROM();
	VS_Init(IsHardReset);
}

CTMapperInfo	MapperInfo_099 =
{
	"VS Unisystem",
	99,
	MS_Full,
	32768,
	InitMapper,
	NULL,
	HBlank,
	NULL,
	NULL,
	NULL,
	NULL,
	VS_MenuClick
};