#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC1.h"
#include	<stdio.h>

static	struct
{
	u32 Counter, MaxCount;
	u8 CounterEnabled;
	u8 InitState;
	u8 FrameNum;
}	Mapper;

static	void	Sync (void)
{
	u8 CHRlines = MMC1_GetCHRBankLo();
	MMC1_SyncMirror();
	MMC1_SyncWRAM();
	MP->SetCHR_RAM8(0,0);
	switch (Mapper.InitState)
	{
	case 2:	if (CHRlines & 0x08)
			MMC1_SyncPRG(0x7,0x8);
		else	MP->SetPRG_ROM32(0x8,(CHRlines >> 1) & 0x3);
		if (CHRlines & 0x10)
		{
			Mapper.Counter = 0;
			Mapper.CounterEnabled = 0;
		}
		else
			Mapper.CounterEnabled = 1;
		return;				break;
	case 0:	if (CHRlines & 0x10)
			Mapper.InitState++;	break;
	case 1:	if (~CHRlines & 0x10)
			Mapper.InitState++;	break;
	}
	MP->SetPRG_ROM32(0x8,0);
}

static	void	SaveMI (Ar128 MI)
{
	u32_n Counter;
	u8 x = 0;
	x += MMC1_SaveMI(&MI[x]);
	Counter.l0 = Mapper.Counter;
	MI[x++] = Counter.b0;
	MI[x++] = Counter.b1;
	MI[x++] = Counter.b2;
	MI[x++] = Counter.b3;
	MI[x++] = (u8)(Mapper.MaxCount >> 24);
	MI[x++] = Mapper.CounterEnabled;
	MI[x++] = Mapper.InitState;
}

static	void	LoadMI (const Ar128 MI)
{
	u32_n Counter;
	u8 x = 0;
	x += MMC1_LoadMI(&MI[x]);
	Counter.b0		= MI[x++];
	Counter.b1		= MI[x++];
	Counter.b2		= MI[x++];
	Counter.b3		= MI[x++];
	Mapper.Counter		= Counter.l0;
	Mapper.MaxCount		= MI[x++] << 24;
	Mapper.CounterEnabled	= MI[x++];
	Mapper.InitState	= MI[x++];
	Sync();
}

static	void	HBlank (int Scanline,int Byte2001)
{
	Mapper.FrameNum++;
	if (Scanline)
		return;
	if (Mapper.CounterEnabled)
	{
		Mapper.Counter += 29781;
		if (!(Mapper.FrameNum % 15))
		{
			char tmp[256];
			u32 SecondsLeft = ((Mapper.MaxCount | 0x20000000) - Mapper.Counter) / 1786830;
			sprintf(tmp,"Time left: %02i:%02i",SecondsLeft / 60,SecondsLeft % 60);
			Mapper.FrameNum = 0;
			MP->StatusOut(tmp);
		}
	}
	if (((Mapper.Counter | (Mapper.MaxCount ^ 0x1E000000)) & 0x3E000000) == 0x3E000000)
	{
		MP->StatusOut("Time up!");
		MP->IRQ();
	}
}

static	void	MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case 0:	switch (Parm1)
		{
		case 0:	Mapper.MaxCount ^= 0x02000000;	break;
		case 1:	Mapper.MaxCount ^= 0x04000000;	break;
		case 2:	Mapper.MaxCount ^= 0x08000000;	break;
		case 3:	Mapper.MaxCount ^= 0x10000000;	break;
		}	break;
	}
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	if (IsHardReset)
		Mapper.MaxCount = 0x00000000;
	MP->AddMenuItem(MP->GetMenuRoot(),"Default time: 5:01",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"+0:19",0,0,-1,-1,(Mapper.MaxCount & 0x10000000) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(MP->GetMenuRoot(),"+0:38",0,1,-1,-1,(Mapper.MaxCount & 0x08000000) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(MP->GetMenuRoot(),"+1:16",0,2,-1,-1,(Mapper.MaxCount & 0x04000000) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(MP->GetMenuRoot(),"+2:30",0,3,-1,-1,(Mapper.MaxCount & 0x02000000) ? MENU_CHECKED : MENU_UNCHECKED);
	
	Mapper.Counter = 0;
	Mapper.CounterEnabled = 0;
	Mapper.InitState = 0;
	Mapper.FrameNum = 0;
	MMC1_Init(Sync);
}

CTMapperInfo	MapperInfo_105 =
{
	"Nintendo World Championship",
	105,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	MenuClick
};