#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	void	Sync (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0xFF,0);
}

static	int	TileHandler (int Bank, int TileNum, int Index)
{
	if (MMC3_GetCHRBank(Bank | (TileNum >> 6)) & 0x80)
		MP->Mirror_S1();
	else	MP->Mirror_S0();
	return 1;
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	iNES_InitROM();
	MP->SetPRG_RAM8(0x6,0);		/* WRAM for TKSROM */
	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_118 =
{
	"TKSROM/TLSROM (MMC3)",
	118,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	TileHandler,
	MMC3_SaveMI,
	MMC3_LoadMI,
	NULL,
	NULL
};