#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

static	void	Sync (void)
{
	u8 x, y;
	MMC3_SyncMirror();
	MMC3_SyncPRG(0x3F,0);
	for (x = 0; x < 8; x++)
	{
		y = MMC3_GetCHRBank(x);
		if (y & 0x40)
			MP->SetCHR_RAM1(x,y & 0x07);
		else	MP->SetCHR_ROM1(x,y & 0x3F);
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	iNES_InitROM();
	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_119 =
{
	"TQROM (MMC3)",
	119,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	MMC3_SaveMI,
	MMC3_LoadMI,
	NULL,
	NULL
};