#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_VS.h"

static	void	Write (int Bank, int Where, int What)
{
	switch (Bank)
	{
	case 0x8:	MP->SetPRG_ROM8(0x8,What);		break;
	case 0xA:	MP->SetPRG_ROM8(0xA,What);		break;
	case 0xC:	MP->SetPRG_ROM8(0xC,What);		break;
	case 0xE:	MP->SetCHR_ROM4(0,What);		break;
	case 0xF:	MP->SetCHR_ROM4(4,What);		break;
	}
}

static	void	HBlank (int Scanline, int Byte2001)
{
	VS_CheckCoin(Scanline);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,Write);

	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	VS_Init(IsHardReset);
}

CTMapperInfo	MapperInfo_151 =
{
	"Extended VS Unisystem",
	151,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	NULL,
	NULL,
	NULL,
	VS_MenuClick
};