#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd;
	u8 IRQenabled, IRQcounter;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Cmd;
	MI[x++] = Mapper.IRQenabled;
	MI[x++] = Mapper.IRQcounter;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Cmd		= MI[x++];
	Mapper.IRQenabled	= MI[x++];
	Mapper.IRQcounter	= MI[x++];
}

static	void	HBlank (int Scanline, int Byte2001)
{
	if ((Mapper.IRQenabled) && (Scanline < 240) && (Byte2001 & 0x18))
	{
		Mapper.IRQcounter--;
		if (Mapper.IRQcounter == 0)
		{
			Mapper.IRQenabled = 0;
			MP->IRQ();
		}
	}
}

static	void	PRG_Write_8 (int Bank, int Where, int What)
{
	if (What & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	PRG_Write_A (int Bank, int Where, int What)
{
	Mapper.Cmd = What;
}

static	void	PRG_Write_C (int Bank, int Where, int What)
{
	switch (Mapper.Cmd)
	{
	case 0:	MP->SetCHR_ROM2(0,What >> 1);	break;
	case 1:	MP->SetCHR_ROM1(5,What);	break;
	case 2:	MP->SetCHR_ROM2(2,What >> 1);	break;
	case 3:	MP->SetCHR_ROM1(7,What);	break;
	case 4:	MP->SetPRG_ROM8(0x8,What);	break;
	case 5:	MP->SetPRG_ROM8(0xA,What);	break;
	case 6:	MP->SetCHR_ROM1(4,What);	break;
	case 7:	MP->SetCHR_ROM1(6,What);	break;
	}
}

static	void	PRG_Write_E (int Bank, int Where, int What)
{
	Mapper.IRQcounter = What;
	Mapper.IRQenabled = What;
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x8,PRG_Write_8);
	MP->SetWriteHandler(0xA,PRG_Write_A);
	MP->SetWriteHandler(0xC,PRG_Write_C);
	MP->SetWriteHandler(0xE,PRG_Write_E);

	MP->SetPRG_ROM32(0x8,-1);
	MP->SetCHR_ROM8(0,0);

	iNES_InitROM();

	Mapper.IRQcounter = Mapper.IRQenabled = 0;
	Mapper.Cmd = 0;
}

CTMapperInfo	MapperInfo_182 =
{
	"Super Donkey Kong",
	182,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
