#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetPRG_ROM16(0x8,0);
	MP->SetPRG_ROM16(0xC,-1);
	MP->SetCHR_ROM4(0,(_74xx.Data & 0x0F) >> 0);
	MP->SetCHR_ROM4(4,(_74xx.Data & 0xF0) >> 4);
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_184 =
{
	"Mapper 184",
	184,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};