#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRbank : 6;
			unsigned PRG16   : 1;
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_HV  : 1;
			unsigned         : 2;
		} b;
		u16 n;
	}	Addr;
	Addr.n = _74xx.Addr;

	MP->SetCHR_ROM8(0,Addr.b.CHRbank);
	if (Addr.b.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,(Addr.b.PRGbank << 1) | (Addr.b.PRG16));
		MP->SetPRG_ROM16(0xC,(Addr.b.PRGbank << 1) | (Addr.b.PRG16));
	}
	else MP->SetPRG_ROM32(0x8,Addr.b.PRGbank);
	if (Addr.b.Mir_HV) MP->Mirror_H();
	else MP->Mirror_V();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_225 =
{
	"72-in-1",
	225,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};