#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Byte8000, Byte8001;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Byte8000;
	MI[x++] = Mapper.Byte8001;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Byte8000	= MI[x++];
	Mapper.Byte8001	= MI[x++];
}

static	void	PRG_Write_89ABCDEF (int Bank, int Where, int What)
{
	union
	{
		struct
		{
			unsigned PRGbank : 5;
			unsigned PRGsize : 1;
			unsigned Mir_VH  : 1;
			unsigned PRGhi   : 2;
			unsigned         : 7;
		} b;
		struct
		{
			u8 b0;
			u8 b1;
		} n;
	}	Val;

	switch (Where & 1)
	{
	case 0:	Mapper.Byte8000 = What;		break;
	case 1:	Mapper.Byte8001 = What;		break;
	}
	Val.n.b0 = Mapper.Byte8000;
	Val.n.b1 = Mapper.Byte8001;

	if (Val.b.Mir_VH)
		MP->Mirror_V();
	else	MP->Mirror_H();
	if (Val.b.PRGsize)
	{
		MP->SetPRG_ROM16(0x8,((Val.b.PRGhi) << 5) | (Val.b.PRGbank));
		MP->SetPRG_ROM16(0xC,((Val.b.PRGhi) << 5) | (Val.b.PRGbank));
	}
	else MP->SetPRG_ROM32(0x8,((Val.b.PRGhi) << 4) | (Val.b.PRGbank >> 1));
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,PRG_Write_89ABCDEF);

	MP->SetPRG_ROM32(0x8,0);
	MP->SetCHR_RAM8(0,0);
	Mapper.Byte8000 = Mapper.Byte8001 = 0;
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_226 =
{
	"76-in-1",
	226,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};