#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRGsize : 1;
			unsigned Mir_HV  : 1;
			unsigned PRG16   : 1;
			unsigned PRGbank : 4;
			unsigned CHRprot : 1;
			unsigned PRGchip : 1;
			unsigned LastBank: 1;
			unsigned         : 9;
		} b;
		u16 n;
	}	Addr;
	Addr.n = _74xx.Addr;

	MP->SetCHR_RAM8(0,0);

	if (Addr.b.Mir_HV) MP->Mirror_H();
	else MP->Mirror_V();
	if (!Addr.b.PRGsize) 
	{
		MP->SetPRG_ROM16(0x8,(Addr.b.PRGchip << 5) | (Addr.b.PRGbank << 1) | (Addr.b.PRG16));
		MP->SetPRG_ROM16(0xC,(Addr.b.PRGchip << 5) | (Addr.b.PRGbank << 1) | (Addr.b.PRG16));
	}
	else	MP->SetPRG_ROM32(0x8,(Addr.b.PRGchip << 4) | (Addr.b.PRGbank));

	if (Addr.b.CHRprot)
		;	/* Protect CHR */
	else
	{	/* Unprotect CHR */
		if (Addr.b.LastBank)
			MP->SetPRG_ROM16(0xC,(Addr.b.PRGchip << 5) | (Addr.b.PRGbank << 1) |  7);
		else	MP->SetPRG_ROM16(0xC,(Addr.b.PRGchip << 5) | (Addr.b.PRGbank << 1) & ~7);
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_227 =
{
	"1200-in-1",
	227,
	MS_Full,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};