#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned CHRbank : 4;
			unsigned         : 1;
			unsigned PRGsize : 1;
			unsigned PRG16   : 1;
			unsigned PRGbank : 4;
			unsigned PRGchip : 2;
			unsigned Mir_HV  : 1;
			unsigned         : 2;
		} b;
		struct
		{
			unsigned n       :16;
		};
	}	Addr;
	u8 openbus = 0;
	Addr.n = _74xx.Addr;

	if (Addr.b.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
	
	switch (Addr.b.PRGchip)
	{
	case 2:	openbus = 1;		break;
	case 3:	Addr.b.PRGchip = 2;	break;
	}
	if (openbus)
	{
		for (openbus = 0x8; openbus <= 0xF; openbus++)
			MP->SetPRG_OB4(openbus);
	}
	else
	{
		if (Addr.b.PRGsize)
		{
			MP->SetPRG_ROM16(0x8,(Addr.b.PRGchip << 5) | (Addr.b.PRGbank << 1) | (Addr.b.PRG16));
			MP->SetPRG_ROM16(0xC,(Addr.b.PRGchip << 5) | (Addr.b.PRGbank << 1) | (Addr.b.PRG16));
		}
		else MP->SetPRG_ROM32(0x8,(Addr.b.PRGchip << 4) | (Addr.b.PRGbank));
	}
	MP->SetCHR_ROM8(0,(Addr.b.CHRbank << 2) | (_74xx.Data & 0x3));
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_228 =
{
	"Action 52",
	228,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};