#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	MP->SetCHR_RAM8(0,0);
	if (_74xx.Addr & 0x20)
		MP->SetPRG_ROM32(0x8,(_74xx.Addr & 0x1E) >> 1);
	else
	{
		MP->SetPRG_ROM16(0x8,_74xx.Addr & 0x1E);
		MP->SetPRG_ROM16(0xC,_74xx.Addr & 0x1E);
	}
	switch ((_74xx.Addr & 0xC0) >> 6)
	{
	case 0:	MP->Mirror_S0();		break;
	case 1:	MP->Mirror_V();			break;
	case 2:	MP->Mirror_H();			break;
	case 3:	MP->Mirror_Custom(0,1,1,1);	break;
	}
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
}

CTMapperInfo	MapperInfo_231 =
{
	"20-in-1",
	231,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};