#include	"..\DLL\d_iNES.h"

static	struct
{
	int WhichGame;
	int WhichBank;
}	Mapper;

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.WhichGame;
	MI[x++] = Mapper.WhichBank;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.WhichGame	= MI[x++];
	Mapper.WhichBank	= MI[x++];
}

static	void	SyncPRG (void)
{
	MP->SetPRG_ROM16(0x8,Mapper.WhichGame | Mapper.WhichBank);
	MP->SetPRG_ROM16(0xC,Mapper.WhichGame | 3);
}

static	void	PRG_Write_9 (int Bank, int Where, int What)
{
	Mapper.WhichGame = (What & 0x18) >> 1;
	SyncPRG();
}

static	void	PRG_Write_ABCDEF (int Bank, int Where, int What)
{
	Mapper.WhichBank = What & 3;
	SyncPRG();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	MP->SetWriteHandler(0x9,PRG_Write_9);
	MP->SetWriteHandler(0xA,PRG_Write_ABCDEF);
	MP->SetWriteHandler(0xB,PRG_Write_ABCDEF);
	MP->SetWriteHandler(0xC,PRG_Write_ABCDEF);
	MP->SetWriteHandler(0xD,PRG_Write_ABCDEF);
	MP->SetWriteHandler(0xE,PRG_Write_ABCDEF);
	MP->SetWriteHandler(0xF,PRG_Write_ABCDEF);

	MP->SetCHR_RAM8(0,0);

	iNES_InitROM();

	Mapper.WhichGame = 0;
	Mapper.WhichBank = 3;

	SyncPRG();
}

CTMapperInfo	MapperInfo_232 =
{
	"Camerica 9096",
	232,
	MS_Nearly,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};