#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_74xx.h"

static	void	Sync (void)
{
	union
	{
		struct
		{
			unsigned PRGbank : 5;
			unsigned         : 3;
			unsigned PRGchip : 2;
			unsigned Mir_S0  : 1;	/* S0 if 1, H/V if 0 */
			unsigned PRGsize : 1;
			unsigned PRG16   : 1;
			unsigned Mir_HV  : 1;	/* H if 1, V if 0 */
			unsigned         : 2;
		};
		struct
		{
			unsigned n       : 16;
		};
	}	Addr;
	u8 openbus = 0;
	Addr.n = _74xx.Addr;
	if (MP->PRG_ROM_Size == 1048576)	/* 1MB, 100-in-1 */
	{
		switch (Addr.PRGchip)
		{
		case 0:			break;
		case 1:	openbus = 1;	break;
		case 2:	openbus = 1;	break;
		case 3:	openbus = 1;	break;
		}
	}
	else if (MP->PRG_ROM_Size == 2097152)	/* 2MB, 150-in-1 */
	{
		switch (Addr.PRGchip)
		{
		case 0:			break;
		case 1:	openbus = 1;	break;
		case 2:	Addr.PRGchip = 1;
					break;
		case 3:	openbus = 1;	break;
		}
	}					/* else 260-in-1 */
	if (openbus)
	{
		for (openbus = 0x8; openbus < 0x10; openbus++)
			MP->SetPRG_OB4(openbus);
	}
	else
	{
		if (Addr.PRGsize)
		{
			MP->SetPRG_ROM16(0x8,(Addr.PRGchip << 6) | (Addr.PRGbank << 1) | (Addr.PRG16));
			MP->SetPRG_ROM16(0xC,(Addr.PRGchip << 6) | (Addr.PRGbank << 1) | (Addr.PRG16));
		}
		else	MP->SetPRG_ROM32(0x8,(Addr.PRGchip << 5) | Addr.PRGbank);
	}
	MP->SetCHR_RAM8(0,0);
	if (Addr.Mir_S0)
		MP->Mirror_S0();
	else if (Addr.Mir_HV)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	iNES_InitROM();
}

CTMapperInfo	MapperInfo_235 =
{
	"Golden Game 150-in-1",
	235,
	MS_Full,
	16384,
	InitMapper,
	NULL,
	NULL,
	NULL,
	_74xx_SaveMI,
	_74xx_LoadMI,
	NULL,
	NULL
};