#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 Cmd, PRG, CHR, Mirror;
	PWriteFunc Write4;
}	Mapper;

static	void	Sync (void)
{
	MP->SetPRG_ROM32(0x8,Mapper.PRG);
	MP->SetCHR_ROM8(0,Mapper.CHR);
	if (Mapper.Mirror)
		MP->Mirror_V();
	else	MP->Mirror_H();
}

static	void	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.Cmd;
	MI[x++] = Mapper.PRG;
	MI[x++] = Mapper.CHR;
	MI[x++] = Mapper.Mirror;
}

static	void	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.Cmd	= MI[x++];
	Mapper.PRG	= MI[x++];
	Mapper.CHR	= MI[x++];
	Mapper.Mirror	= MI[x++];
	Sync();
}

static	void	Write (int Bank, int Where, int What)
{
	u16 Loc = (Bank << 12) | Where;
	if (Loc < 0x4018)
	{
		Mapper.Write4(Bank,Where,What);
		return;
	}
	switch (Loc & 0x4101)
	{
	case 0x4100:	Mapper.Cmd = What & 7;	break;
/*	case 0x4101:	switch (Mapper.Cmd)
			{
			case 0:	Mapper.PRG = 0;
				Mapper.CHR = 3;			break;

			case 2:	Mapper.CHR &= ~0x4;
				Mapper.CHR |= (What & 1) << 2;	break;
			case 4:	Mapper.CHR &= ~0x2;
				Mapper.CHR |= (What & 1) << 1;	break;
			case 6:	Mapper.CHR &= ~0x1;
				Mapper.CHR |= (What & 1) << 0;	break;

			case 5:	Mapper.PRG = What & 0x1;	break;
			case 7:	Mapper.Mirror = (What & 1);	break;
			}			break;*/
	case 0x4101:	switch (Mapper.Cmd)
			{
			case 0:	Mapper.PRG = 0;
				Mapper.CHR = 3;				break;
			case 4:	Mapper.CHR &= (0x3) << 1;
				Mapper.CHR |= (What & 0x1) >> 0;	break;
			case 5:	Mapper.PRG = What & 0x1;		break;
			case 6:	Mapper.CHR &= (0x1) >> 0;
				Mapper.CHR |= (What & 0x3) << 1;	break;
			case 7:	Mapper.Mirror = (What & 1);		break;
			}			break;

	}
	Sync();
}

static	void	UnloadMapper (void)
{
	iNES_UnloadROM();
}

/*static	void	MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case 0:	Mapper.CHR = Parm1;
		Sync();			break;
	}
}*/

static	void	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	Mapper.Write4 = MP->GetWriteHandler(0x4);
	for (x = 0x4; x < 0x8; x++)
		MP->SetWriteHandler(x,Write);

	iNES_InitROM();

	Mapper.Cmd = 0;
	Mapper.PRG = 0;
	Mapper.CHR = 3;
	Mapper.Mirror = 0;
	Sync();
/*	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 0",0,0,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 1",0,1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 2",0,2,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 3",0,3,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 4",0,4,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 5",0,5,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 6",0,6,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"Set CHR to 7",0,7,-1,-1,MENU_NOCHECK);*/
}

CTMapperInfo	MapperInfo_243 =
{
	"Mapper 243 (Sachen)",
	243,
	MS_Partial,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};