/*
 * NESten Mapper Interface v2.1
 */

#ifndef	WIN32_LEAN_AND_MEAN
#define	WIN32_LEAN_AND_MEAN
#endif

/* So this file only gets included once */

#ifndef	__INTERFACE_H__
#define	__INTERFACE_H__

/* Standard header files, used by all mappers */

#include	<windows.h>

#define	MSGBOX_FLAGS	(MB_OK | MB_ICONERROR | MB_DEFBUTTON1 | MB_APPLMODAL)

/* Mapper Interface version (2.1) */

#define	CurrentMapperInterface 0x00020001

/* Integer types */

typedef	signed char	s8;
typedef	signed short	s16;
typedef	signed long	s32;

typedef	unsigned char	u8;
typedef	unsigned short	u16;
typedef	unsigned long	u32;

typedef	union
{
	struct
	{
		unsigned n0 : 4;
		unsigned n1 : 4;
	};
	struct
	{
		unsigned b0 : 8;
	};
}	u8_n;

typedef	union
{
	struct
	{
		unsigned n0 : 4;
		unsigned n1 : 4;
		unsigned n2 : 4;
		unsigned n3 : 4;
	};
	struct
	{
		unsigned b0 : 8;
		unsigned b1 : 8;
	};
	struct
	{
		unsigned s0 :16;
	};
}	u16_n;

typedef	union
{
	struct
	{
		unsigned n0 : 4;
		unsigned n1 : 4;
		unsigned n2 : 4;
		unsigned n3 : 4;
		unsigned n4 : 4;
		unsigned n5 : 4;
		unsigned n6 : 4;
		unsigned n7 : 4;
	};
	struct
	{
		unsigned b0 : 8;
		unsigned b1 : 8;
		unsigned b2 : 8;
		unsigned b3 : 8;
	};
	struct
	{
		unsigned s0 :16;
		unsigned s1 :16;
	};
	struct
	{
		unsigned l0 :32;
	};
}	u32_n;

/* Function types */

typedef	void	(*PWriteFunc)	(int,int,int);
typedef	int	(*PReadFunc)	(int,int);

/* The Mapper Interface Structure - Pointers to data and functions within NESten */

typedef	struct	MapperParam
{
	/* .NES Header information */
		int		Flags;			/* Mapper flags */
		int		PRG_ROM_Size;		/* PRG_ROM size in bytes */
		int		CHR_ROM_Size;		/* CHR_ROM size in bytes */
		int		Unused;

	/* Functions for managing read/write handlers */
		void		(*SetWriteHandler)	(int,PWriteFunc);
		void		(*SetReadHandler)	(int,PReadFunc);
		PWriteFunc	(*GetWriteHandler)	(int);
		PReadFunc	(*GetReadHandler)	(int);

	/* Functions for mapping PRG */
		void		(*SetPRG_ROM4)		(int,int);
		void		(*SetPRG_ROM8)		(int,int);
		void		(*SetPRG_ROM16)		(int,int);
		void		(*SetPRG_ROM32)		(int,int);
		int		(*GetPRG_ROM4)		(int);		/* -1 if no ROM mapped */
#define		GetPRG_ROM8(x)	GetPRG_ROM4(x) >> 1
#define		GetPRG_ROM16(x)	GetPRG_ROM4(x) >> 2
		void		(*SetPRG_RAM4)		(int,int);
		void		(*SetPRG_RAM8)		(int,int);
		void		(*SetPRG_RAM16)		(int,int);
		void		(*SetPRG_RAM32)		(int,int);
		int		(*GetPRG_RAM4)		(int);		/* -1 if no RAM mapped */
#define		GetPRG_RAM8(x)	GetPRG_RAM4(x) >> 1
		char *		(*GetPRG_Ptr4)		(int);
		
		void		(*SetPRG_OB4)		(int);		/* Open bus */

	/* Functions for mapping CHR */
		void		(*SetCHR_ROM1)		(int,int);
		void		(*SetCHR_ROM2)		(int,int);
		void		(*SetCHR_ROM4)		(int,int);
		void		(*SetCHR_ROM8)		(int,int);
		int		(*GetCHR_ROM1)		(int);		/* -1 if no ROM mapped */

		void		(*SetCHR_RAM1)		(int,int);
		void		(*SetCHR_RAM2)		(int,int);
		void		(*SetCHR_RAM4)		(int,int);
		void		(*SetCHR_RAM8)		(int,int);
		int		(*GetCHR_RAM1)		(int);		/* -1 if no RAM mapped */
		
		char *		(*GetCHR_Ptr1)		(int);
/*		void		(*SetCHR_OB1)		(int);		/* Open bus */

	/* Functions for controlling mirroring */
		void		(*Mirror_H)		(void);
		void		(*Mirror_V)		(void);
		void		(*Mirror_4)		(void);
		void		(*Mirror_S0)		(void);
		void		(*Mirror_S1)		(void);
		void		(*Mirror_Custom)	(int,int,int,int);

	/* IRQ */
		void		(*IRQ)			(void);

	/* Save RAM Handling */
		void		(*Set_SRAMSize)		(int);		/* Sets the size of the SRAM (in bytes) */
		void		(*Save_SRAM)		(void);		/* Saves SRAM to disk */
		void		(*Load_SRAM)		(void);		/* Loads SRAM from disk */

	/* Misc Callbacks */
		void		(*DbgOut)		(char *);	/* Echo text to debug window */
		void		(*StatusOut)		(char *);	/* Echo text on status bar */
		int		(*GetMenuRoot)		(void);		/* Gets root menu */
		int		(*AddMenuItem)		(int,char *,int,int,int,int,int);
									/* Adds menu item, returns menu handle (for submenus) */
	/* Special Chip functions */
	/* MMC5 */
		void		(*MMC5_UpdateAttributeCache)
							(void);		/* Update attribute cache for ExRAM gfx mode */
}	TMapperParam, *PMapperParam;

extern PMapperParam MP;

typedef	u8	Ar128[128];

#define		MS_None		0
#define		MS_Partial	1
#define		MS_Nearly	2
#define		MS_Full		3

#define		MENU_NOCHECK	0
#define		MENU_UNCHECKED	1
#define		MENU_CHECKED	2

/* Mapper Information structure - Contains pointers to mapper functions, sent to NESten on load mapper  */

typedef	struct	MapperInfo
{
	/* Mapper Information */
		char *		BoardName;
		int		MapperNum;
		int		MapperSupport;
		int		BankSize;

	/* Mapper Functions */
		void		(*InitMapper)	(const PMapperParam,int);
		void		(*UnloadMapper)	(void);
		void		(*HBlank)	(int,int);
		int		(*TileHandler)	(int,int,int);
		void		(*SaveMI)	(Ar128);
		void		(*LoadMI)	(const Ar128);
		void		(*MapperSnd)	(s16 *,int);
		void		(*MenuClick)	(int,int,int,int);
}	TMapperInfo, *PMapperInfo;
typedef	const	TMapperInfo	CTMapperInfo, *CPMapperInfo;

/* DLL Information Structure:- Contains general information about the mapper DLL */

typedef	struct	DLLInfo
{
		char *		Author;
		int		Date;
		int		Version;
		CPMapperInfo	(*LoadMapper)	(int);
		CPMapperInfo	(*LoadBoard)	(char *);
}	TDLLInfo, *PDLLInfo;

#endif	/* __INTERFACE_H__ */