#include	"..\..\interface.h"
#include	"s_FME07.h"

static	TFME07sound	FME07sound;

static	void	FME07_DoSquare (PFME07sqr ChanData, s16 *Target, int Size)
{
	int x;
	for (x = 0; x < Size; x++)
	{
		ChanData->LCtr -= NES_INC_SIZE_INT;
		while (ChanData->LCtr < 0)
		{
			ChanData->CurP++;
			ChanData->CurP &= 0xF;
			ChanData->LCtr += (ChanData->freq + 1) << 16;
		}
		Target[x] += ChanData->volume * ((ChanData->CurP <= 8) ? 4 : -4);
	}
}

static	void	FME07_DoNoise (PFME07noise ChanData, s16 *Target, int Size)
{
	int x, volume;

        volume = 0;
        for (x = 0; x < 3; x++)
	{
		if (!(FME07sound.noise & (1 << x)))
			volume += FME07sound.Sqr[x].volume;	/* 1 noise for each channel */
	}
	for (x = 0; x < Size; x++)
	{
		ChanData->LCtr -= NES_INC_SIZE_INT;
		while (ChanData->LCtr < 0)
		{
			ChanData->ShiftReg.s0 = (ChanData->ShiftReg.s0 << 1) | ((ChanData->ShiftReg.s0 >> 13) & 1) ^ ((ChanData->ShiftReg.s0 >> 14) & 1);
			ChanData->LCtr += (ChanData->freq + 1) << 16;
		}
		Target[x] += volume * ((ChanData->ShiftReg.s0 & 1) ? 4 : -4);
	}
}

void	FME07sound_Init (void)
{
	memset(&FME07sound,0,sizeof(FME07sound));
	FME07sound.Noise.ShiftReg.s0 = 0xFFFF;
}

void	FME07sound_Write (int Where, int What)
{
	switch (Where & 0xE000)
	{
	case 0xC000:	FME07sound.select = What & 0xF;	break;	
	case 0xE000:	switch (FME07sound.select)
			{
			case 0x0:	FME07sound.Sqr[0].byte0 = What;	break;
			case 0x1:	FME07sound.Sqr[0].byte1 = What;	break;
			case 0x2:	FME07sound.Sqr[1].byte0 = What;	break;
			case 0x3:	FME07sound.Sqr[1].byte1 = What;	break;
			case 0x4:	FME07sound.Sqr[2].byte0 = What;	break;
			case 0x5:	FME07sound.Sqr[2].byte1 = What;	break;
			case 0x6:	FME07sound.Noise.byte0 = What;	break;
			case 0x7:	FME07sound.byte7 = What;	break;
			case 0x8:	FME07sound.Sqr[0].byte2 = What;	break;
			case 0x9:	FME07sound.Sqr[1].byte2 = What;	break;
			case 0xA:	FME07sound.Sqr[2].byte2 = What;	break;
			case 0xB:	FME07sound.byteB = What;	break;
			case 0xC:	FME07sound.byteC = What;	break;
			case 0xD:	FME07sound.byteD = What;	break;
			}				break;
	}
}

void	FME07sound_Get (s16 *Target, int Size)
{
	if (!(FME07sound.tone & 1))	FME07_DoSquare(&FME07sound.Sqr[0],Target,Size);
	if (!(FME07sound.tone & 2))	FME07_DoSquare(&FME07sound.Sqr[1],Target,Size);
	if (!(FME07sound.tone & 4))	FME07_DoSquare(&FME07sound.Sqr[2],Target,Size);
	if (!FME07sound.noise)		FME07_DoNoise(&FME07sound.Noise,Target,Size);
}

int	FME07sound_SaveMI (Ar128 MI, int x)
{
	MI[x++] = FME07sound.Sqr[0].byte0;
	MI[x++] = FME07sound.Sqr[0].byte1;
	MI[x++] = FME07sound.Sqr[0].byte2;
	MI[x++] = FME07sound.Sqr[1].byte0;
	MI[x++] = FME07sound.Sqr[1].byte1;
	MI[x++] = FME07sound.Sqr[1].byte2;
	MI[x++] = FME07sound.Sqr[2].byte0;
	MI[x++] = FME07sound.Sqr[2].byte1;
	MI[x++] = FME07sound.Sqr[2].byte2;
	MI[x++] = FME07sound.Noise.byte0;
	MI[x++] = FME07sound.Noise.ShiftReg.b0;
	MI[x++] = FME07sound.Noise.ShiftReg.b1;
	MI[x++] = FME07sound.select;
	return x;
}

int	FME07sound_LoadMI (const Ar128 MI, int x)
{
	FME07sound.Sqr[0].byte0 = MI[x++];
	FME07sound.Sqr[0].byte1 = MI[x++];
	FME07sound.Sqr[0].byte2 = MI[x++];
	FME07sound.Sqr[1].byte0 = MI[x++];
	FME07sound.Sqr[1].byte1 = MI[x++];
	FME07sound.Sqr[1].byte2 = MI[x++];
	FME07sound.Sqr[2].byte0 = MI[x++];
	FME07sound.Sqr[2].byte1 = MI[x++];
	FME07sound.Sqr[2].byte2 = MI[x++];
	FME07sound.Noise.byte0 = MI[x++];
	FME07sound.Noise.ShiftReg.b0 = MI[x++];
	FME07sound.Noise.ShiftReg.b1 = MI[x++];
	FME07sound.select = MI[x++];
	return x;
}

void	FME07sound_Destroy (void)
{
}