#ifndef __74XX_H__
#define	__74XX_H__

#include	"..\interface.h"

/* #define	BUS_CONFLICTS	/* Enable bus conflict checking, only use for debug builds */

typedef	struct	_74xx
{
	u8 Data;
	union
	{
		struct
		{
			unsigned AddrL : 8;
			unsigned AddrH : 8;
		};
		struct
		{
			unsigned Addr  :16;
		};
	};
	void	(*Sync)	(void);
	int BusConflicts;
}	T_74xx, P_74xx;

extern	T_74xx	_74xx;

void		_74xx_Init	(void (*)(void),BOOL,BOOL);
void		_74xx_Destroy	(void);
int		_74xx_SaveMI_AD	(Ar128,int);
int		_74xx_LoadMI_AD	(const Ar128,int);
int		_74xx_SaveMI_AL	(Ar128,int);
int		_74xx_LoadMI_AL	(const Ar128,int);
int		_74xx_SaveMI_A	(Ar128,int);
int		_74xx_LoadMI_A	(const Ar128,int);
int		_74xx_SaveMI_D	(Ar128,int);
int		_74xx_LoadMI_D	(const Ar128,int);
void	__cdecl	_74xx_Write	(int,int,int);

#endif	/* __74XX_H__ */