#include	"h_FDS.h"
#include	"Sound\s_FDS.h"
#include	<stdio.h>

TFDS	FDS;

int	FDS_SaveMI (Ar128 MI, int x)
{
	MI[x++] = FDS.DiskNum;
	MI[x++] = FDS.IRQcounter & 0xFF;
	MI[x++] = FDS.IRQcounter >> 8;
	MI[x++] = FDS.IRQlatch.b0;
	MI[x++] = FDS.IRQlatch.b1;
	MI[x++] = FDS.IRQenabled;
	MI[x++] = FDS.IOenable;
	MI[x++] = FDS.IOcontrol;
	MI[x++] = FDS.IOstatus;
	MI[x++] = FDS.DriveStatus;
	MI[x++] = FDS.BytePtr & 0xFF;
	MI[x++] = FDS.BytePtr >> 8;
	MI[x++] = FDS.WriteSkip;
	MI[x++] = FDS.DiskIRQ;
	return x;
}

int	FDS_LoadMI (const Ar128 MI, int x)
{
	FDS.DiskNum = MI[x++];
	FDS.IRQcounter = MI[x++];
	FDS.IRQcounter |= MI[x++] << 8;
	FDS.IRQlatch.b0 = MI[x++];
	FDS.IRQlatch.b1 = MI[x++];
	FDS.IRQenabled = MI[x++];
	FDS.IOenable = MI[x++];
	FDS.IOcontrol = MI[x++];
	FDS.IOstatus = MI[x++];
	FDS.DriveStatus = MI[x++];
	FDS.BytePtr = MI[x++];
	FDS.BytePtr |= MI[x++] << 8;
	FDS.WriteSkip = MI[x++];
	FDS.DiskIRQ = MI[x++];
	MP->SetPRG_RAM32(0x6,0);
	MP->SetPRG_RAM4(0xE,8);
	MP->SetPRG_RAM4(0xF,9);
	MP->SetCHR_RAM8(0,0);
	return x;
}

void	__cdecl	FDS_HBlank (int Scanline, int Byte2001)
{
	FDS.IOstatus &= ~0x03;
	if (FDS.IRQenabled)
	{
		if (FDS.IRQcounter < 113)
		{
			FDS.IRQenabled = 0;
			FDS.IRQcounter = 0xFFFF;
			FDS.IOstatus |= 0x01;
			MP->IRQ();
		}
		else	FDS.IRQcounter -= 113;
	}
	else if (FDS.DiskIRQ)
	{
		FDS.DiskIRQ--;
		if ((FDS.DiskIRQ == 0) && (FDS.IOcontrol & 0x80))
		{
			FDS.IOstatus |= 0x02;
			MP->IRQ();
		}
	}
}

#define	DISKIRQ_SHORT	2
#define	DISKIRQ_LONG	2

int	__cdecl	FDS_Read (int Bank, int Where)
{
	if ((Where & 0xFFF) < 0x20)
		return FDS.Read(Bank,Where);
	switch (Where & 0xFFF)
	{
	case 0x30:	return FDS.IOstatus;		break;
	case 0x31:	if (FDS.DiskNum == 0xFF)
				return 0xFF;
			else
			{
				static int Val;
				MP->SetPRG_ROM4(0x6,(FDS.DiskNum << 4) | ((FDS.BytePtr >> 12) & 0xF));
				Val = MP->GetPRG_Ptr4(0x6)[FDS.BytePtr & 0xFFF];
				MP->SetPRG_RAM4(0x6,0);
				if (FDS.IOcontrol & 0x01)
				{
					if (FDS.BytePtr < 64999)
						FDS.BytePtr++;
					if ((FDS.BytePtr & 0xFF) == 0)
					{
						char tmp[256];
						sprintf(tmp,"%i R/S",FDS.BytePtr);
						MP->StatusOut(tmp);
					}
					FDS.DiskIRQ = DISKIRQ_SHORT;
				}
				return Val;
			}				break;
	case 0x32:	return FDS.DriveStatus;		break;
	case 0x33:	return 0x80;			break;
	}
	return FDSsound_Read((Bank << 12) | Where);
}

void	__cdecl	FDS_Write (int Bank, int Where, int What)
{
	if ((Where & 0xFFF) < 0x20)
		FDS.Write(Bank,Where,What);
	FDSsound_Write((Bank << 12) | Where,What);
	switch (Where & 0xFFF)
	{
	case 0x20:	FDS.IRQlatch.b0 = What;	break;
	case 0x21:	FDS.IRQlatch.b1 = What;	break;
	case 0x22:	FDS.IRQenabled = What & 0x02;
			FDS.IRQcounter = FDS.IRQlatch.s0;	break;
	case 0x23:	FDS.IOenable = What;		break;
	case 0x24:	if (FDS.DiskNum == 0xFF)	break;
			if ((FDS.IOenable & 0x1) && (~FDS.IOcontrol & 0x04))
			{
				if ((FDS.BytePtr >= 0) && (FDS.BytePtr < 65000))
				{
					if (FDS.WriteSkip) FDS.WriteSkip--;
					else if (FDS.BytePtr >= 2)
					{
						char tmp[256];
						sprintf(tmp,"%i W",FDS.BytePtr);
						MP->StatusOut(tmp);
						FDS.BytePtr -= 2;
						MP->SetPRG_ROM4(0x6,(FDS.DiskNum << 4) | ((FDS.BytePtr >> 12) & 0xF));
						MP->GetPRG_Ptr4(0x6)[FDS.BytePtr & 0xFFF] = What;
						MP->SetPRG_RAM4(0x6,0);
						FDS.BytePtr += 2;
					}
				}
			}				break;
	case 0x25:	if (What & 0x08)
				MP->Mirror_H();
			else	MP->Mirror_V();
			if (FDS.DiskNum == 0xFF)	break;
			if (~What & 0x40)
			{
				if ((FDS.IOcontrol & 0x40) && (~What & 0x10))
				{
					char tmp[256];
					FDS.BytePtr -= 2;
					if (FDS.BytePtr < 0)
						FDS.BytePtr = 0;
					sprintf(tmp,"%i S",FDS.BytePtr);
					MP->StatusOut(tmp);
					FDS.DiskIRQ = DISKIRQ_LONG;
				}
			}
			if (~What & 0x04)
				FDS.WriteSkip = 2;
			FDS.IOcontrol = What;
			if (What & 0x02)
			{
				char tmp[256];
				sprintf(tmp,"%i S",FDS.BytePtr);
				MP->StatusOut(tmp);
				FDS.BytePtr = 0;
				FDS.DiskIRQ = DISKIRQ_LONG;
			}
			if (What & 0x80)
				FDS.DiskIRQ = DISKIRQ_LONG;
							break;
	case 0x26:	/* Dunno */			break;
	}
}

static	void	__cdecl	WriteBIOS (int Bank, int Where, int What)
{	/* don't allow writing to BIOS! */	}

void	__cdecl	FDS_MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	char tmp[256];
	switch (Command)
	{
	case 0:	FDS.DiskNum = 0xFF;
		FDS.DriveStatus |= 0x01;
		MP->StatusOut("Disk ejected!");	break;
	case 1:	FDS.DiskNum = Parm1;
		FDS.DriveStatus &= ~0x01;
		sprintf(tmp,"Disk %i side %s inserted!",(Parm1 >> 1) + 1, (Parm1 & 1) ? "B" : "A");
		MP->StatusOut(tmp);		break;
	}
}

void	__cdecl	FDS_MapperSnd (s16 *Buffer, int Len)
{
	FDSsound_Get(Buffer,Len);
}

void	FDS_Init (void)
{
	FILE *BIOS;
	char buf[256];
	int i;

	FDS.Read = MP->GetReadHandler(0x4);
	MP->SetReadHandler(0x4,FDS_Read);
	FDS.Write = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x4,FDS_Write);

	MP->SetPRG_RAM32(0x6,0);
	MP->SetCHR_RAM8(0,0);

	MP->SetPRG_RAM4(0xE,8);
	MP->SetWriteHandler(0xE,WriteBIOS);
	MP->SetPRG_RAM4(0xF,9);
	MP->SetWriteHandler(0xF,WriteBIOS);


	if (!(i = GetModuleFileName(NULL,buf,255)))
	{
		MessageBox(0,"Fatal error: failed to get directory!","FDS",MSGBOX_FLAGS);
		return;
	}
	while (i > 0)
		if (buf[--i] == '\\')	break;
	buf[i] = 0;
	if ((BIOS = fopen(strcat(buf,"\\disksys.rom"),"rb")) == NULL)
	{
		MessageBox(0,"Disk System BIOS (disksys.rom) not found!","FDS",MSGBOX_FLAGS);
		return;
	}
	if ((fread(MP->GetPRG_Ptr4(0xE),1,4096,BIOS) != 4096) || (fread(MP->GetPRG_Ptr4(0xF),1,4096,BIOS) != 4096))
	{
		fclose(BIOS);
		MessageBox(0,"Disk System BIOS (disksys.rom) too small!","FDS",MSGBOX_FLAGS);
		return;
	}
	fclose(BIOS);

	MP->DbgOut("FDS BIOS loaded!");

	FDS.IOstatus = 0x0;
	FDS.DriveStatus = 0x41;

	MP->AddMenuItem(MP->GetMenuRoot(),"Eject disk",0,0,-1,-1,MENU_NOCHECK);
	for (i = 0; i < (MP->PRG_ROM_Size >> 16); i++)
	{
		sprintf(buf,"Insert disk %i side %s",(i >> 1)+1,(i & 1) ? "B" : "A");
		MP->AddMenuItem(MP->GetMenuRoot(),buf,1,i,-1,-1,MENU_NOCHECK);
	}

	FDS_MenuClick(1,0,-1,-1);	/* Insert Disk 1 Side A */
	FDSsound_Init();
}

void	FDS_Destroy (void)
{
	FDSsound_Destroy();
}