#include	"h_FME07.h"
#include	"Sound\s_FME07.h"

static	TFME07	FME07;

void	FME07_Init (void (*Sync)(void))
{
	FME07.Cmd = 0;

	FME07.PRG[0] = 0x00;	FME07.PRG[1] = 0x00;	FME07.PRG[2] = 0x01;	FME07.PRG[3] = 0xFE;

	FME07.CHR[0] = 0x00;	FME07.CHR[1] = 0x01;	FME07.CHR[2] = 0x02;	FME07.CHR[3] = 0x03;
	FME07.CHR[4] = 0x04;	FME07.CHR[5] = 0x05;	FME07.CHR[6] = 0x06;	FME07.CHR[7] = 0x07;

	FME07.Mirror = 0;

	FME07.IRQenabled = 0;
	FME07.IRQcounter.s0 = 0;
	
	MP->SetWriteHandler(0x8,FME07_Write89);
	MP->SetWriteHandler(0x9,FME07_Write89);
	MP->SetWriteHandler(0xA,FME07_WriteAB);
	MP->SetWriteHandler(0xB,FME07_WriteAB);
	MP->SetWriteHandler(0xC,FME07_WriteCDEF);
	MP->SetWriteHandler(0xD,FME07_WriteCDEF);
	MP->SetWriteHandler(0xE,FME07_WriteCDEF);
	MP->SetWriteHandler(0xF,FME07_WriteCDEF);

	(FME07.Sync = Sync)();
}

void	FME07_Destroy (void)
{
	FME07sound_Destroy();
}

void	FME07_SyncMirror (void)
{
	switch (FME07.Mirror)
	{
	case 0:	MP->Mirror_V();		break;
	case 1:	MP->Mirror_H();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

void	FME07_SyncPRG (int AND, int OR)
{
	if (FME07.PRG[0] & 0x40)
		if (FME07.PRG[0] & 0x80)
			MP->SetPRG_RAM8(0x6,0);
		else
		{
			MP->SetPRG_OB4(0x6);
			MP->SetPRG_OB4(0x7);
		}
	else	MP->SetPRG_ROM8(0x6,(FME07.PRG[0] & 0x3F & AND) | OR);
	MP->SetPRG_ROM8(0x8,(FME07.PRG[1] & AND) | OR);
	MP->SetPRG_ROM8(0xA,(FME07.PRG[2] & AND) | OR);
	MP->SetPRG_ROM8(0xC,(FME07.PRG[3] & AND) | OR);
	MP->SetPRG_ROM8(0xE,(0xFF & AND) | OR);
}

void	FME07_SyncCHR (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,(FME07.CHR[x] & AND) | OR);
}

int	FME07_SaveMI (Ar128 MI, int x)
{
	u8 i;
			MI[x++] = FME07.IRQcounter.b0;
			MI[x++] = FME07.IRQcounter.b1;
			MI[x++] = FME07.IRQenabled;
			MI[x++] = FME07.Cmd;
for (i = 0; i < 4; i++)	MI[x++] = FME07.PRG[i];
for (i = 0; i < 8; i++)	MI[x++] = FME07.CHR[i];
			MI[x++] = FME07.Mirror;
	x = FME07sound_SaveMI(MI,x);
	return x;
}

int	FME07_LoadMI (const Ar128 MI, int x)
{
	u8 i;
			FME07.IRQcounter.b0	= MI[x++];
			FME07.IRQcounter.b1	= MI[x++];
			FME07.IRQenabled	= MI[x++];
			FME07.Cmd		= MI[x++];
for (i = 0; i < 4; i++)	FME07.PRG[i]		= MI[x++];
for (i = 0; i < 8; i++)	FME07.CHR[i]		= MI[x++];
			FME07.Mirror		= MI[x++];
	x = FME07sound_LoadMI(MI,x);
	FME07.Sync();
	return x;
}

void	__cdecl	FME07_Write89 (int Bank, int Where, int What)
{
	FME07.Cmd = What & 0xF;
}

void	__cdecl	FME07_WriteAB (int Bank, int Where, int What)
{
	switch (FME07.Cmd)
	{
	case 0x0:	FME07.CHR[0] = What;	break;
	case 0x1:	FME07.CHR[1] = What;	break;
	case 0x2:	FME07.CHR[2] = What;	break;
	case 0x3:	FME07.CHR[3] = What;	break;
	case 0x4:	FME07.CHR[4] = What;	break;
	case 0x5:	FME07.CHR[5] = What;	break;
	case 0x6:	FME07.CHR[6] = What;	break;
	case 0x7:	FME07.CHR[7] = What;	break;
	case 0x8:	FME07.PRG[0] = What;	break;
	case 0x9:	FME07.PRG[1] = What & 0x3F;	break;
	case 0xA:	FME07.PRG[2] = What & 0x3F;	break;
	case 0xB:	FME07.PRG[3] = What & 0x3F;	break;
	case 0xC:	FME07.Mirror = What & 3;	break;
	case 0xD:	FME07.IRQenabled = What;	break;
	case 0xE:	FME07.IRQcounter.b0 = What;	break;
	case 0xF:	FME07.IRQcounter.b1 = What;	break;
	}
	FME07.Sync();
}

void	__cdecl	FME07_WriteCDEF (int Bank, int Where, int What)
{
	FME07sound_Write((Bank << 12) | Where,What);
	FME07.Sync();
}

void	__cdecl	FME07_HBlank (int Scanline, int Byte2001)
{
	if (FME07.IRQenabled)
	{
		if (FME07.IRQcounter.s0 <= 114)
			MP->IRQ();
		else	FME07.IRQcounter.s0 -= 114;
	}
}

void	__cdecl	FME07_MapperSnd (s16 *Buffer, int Len)
{
	FME07sound_Get(Buffer,Len);
}
