#include	"h_MMC1.h"

static	TMMC1	MMC1;

void	MMC1_Init (void (*Sync)(void))
{
	u8 x;
	MMC1.Regs[0] = 0x0C;
	MMC1.Regs[1] = 0x00;
	MMC1.Regs[2] = 0x00;
	MMC1.Regs[3] = 0x10;
	MMC1.Latch = 0;
	MMC1.LatchPos = 0;
	for (x = 0x8; x <= 0xF; x++)
		MP->SetWriteHandler(x,MMC1_Write);
	(MMC1.Sync = Sync)();
}

void	MMC1_Destroy (void)
{
}

int	MMC1_SaveMI (Ar128 MI, int x)
{
	u8 i;
for (i = 0; i < 4; i++)	MI[x++] = MMC1.Regs[i];
			MI[x++] = MMC1.Latch;
			MI[x++] = MMC1.LatchPos;
	return x;
}

int	MMC1_LoadMI (const Ar128 MI, int x)
{
	u8 i;
for (i = 0; i < 4; i++)	MMC1.Regs[i]	= MI[x++];
			MMC1.Latch	= MI[x++];
			MMC1.LatchPos	= MI[x++];
	MMC1.Sync();
	return x;
}
static	int	LastReg;
void	__cdecl	MMC1_Write (int Bank, int Where, int What)
{
	u8 Reg = (Bank >> 1) & 3;
	if (What & 0x80)
	{
		MMC1.Latch = MMC1.LatchPos = 0;
		return;
	}
	if (Reg != LastReg)
		MMC1.Latch = MMC1.LatchPos = 0;
	LastReg = Reg;
	MMC1.Latch |= (What & 1) << MMC1.LatchPos++;
	if (MMC1.LatchPos == 5)
	{
		MMC1.Regs[Reg] = MMC1.Latch & 0x1F;
		MMC1.Latch = MMC1.LatchPos = 0;
		MMC1.Sync();
	}
}

void	MMC1_SyncMirror (void)
{
	if (MMC1.Regs[0] & 0x2)
		if (MMC1.Regs[0] & 0x1)
			MP->Mirror_H();
		else	MP->Mirror_V();
	else	MP->Mirror_S0();
}

int	MMC1_GetPRGBankLo (void)
{
	if (MMC1.Regs[0] & 0x08)
		if (MMC1.Regs[0] & 0x04)
			return MMC1.Regs[3] & 0xF;
		else	return 0x0;
	else	return (MMC1.Regs[3] & 0xE) | 0;
}

int	MMC1_GetPRGBankHi (void)
{
	if (MMC1.Regs[0] & 0x08)
		if (MMC1.Regs[0] & 0x04)
			return 0xF;
		else	return MMC1.Regs[3] & 0xF;
	else	return (MMC1.Regs[3] & 0xE) | 1;
}

int	MMC1_GetCHRBankLo (void)
{
	if (MMC1.Regs[0] & 0x10)
		return MMC1.Regs[1] & 0x1F;
	else	return (MMC1.Regs[1] & 0x1E) | 0;
}

int	MMC1_GetCHRBankHi (void)
{
	if (MMC1.Regs[0] & 0x10)
		return MMC1.Regs[2] & 0x1F;
	else	return (MMC1.Regs[1] & 0x1E) | 1;
}

BOOL	MMC1_GetWRAMEnabled (void)
{
	return !(MMC1.Regs[3] & 0x10);
}

void	MMC1_SyncPRG (int AND, int OR)
{
	MP->SetPRG_ROM16(0x8,(MMC1_GetPRGBankLo() & AND) | OR);
	MP->SetPRG_ROM16(0xC,(MMC1_GetPRGBankHi() & AND) | OR);
}

void	MMC1_SyncCHR_ROM (int AND, int OR)
{
	MP->SetCHR_ROM4(0,(MMC1_GetCHRBankLo() & AND) | OR);
	MP->SetCHR_ROM4(4,(MMC1_GetCHRBankHi() & AND) | OR);
}

void	MMC1_SyncCHR_RAM (int AND, int OR)
{
	MP->SetCHR_RAM4(0,(MMC1_GetCHRBankLo() & AND) | OR);
	MP->SetCHR_RAM4(4,(MMC1_GetCHRBankHi() & AND) | OR);
}

void	MMC1_SyncWRAM (void)
{
	if (MMC1_GetWRAMEnabled())
		MP->SetPRG_RAM8(0x6,0);
	else
	{
		MP->SetPRG_OB4(0x6);
		MP->SetPRG_OB4(0x7);
	}
}