#include	"h_MMC4.h"

static	TMMC4	MMC4;

void	MMC4_Init (void (*Sync)(void))
{
	u8 x;
	for (x = 0; x < 2; x++)
	{
		MMC4.LatchState[x] = 0xFE;
		MMC4.Latch0[x] = 0;
		MMC4.Latch1[x] = 0;
	}
	MP->SetWriteHandler(0xA,MMC4_WriteA);
	MP->SetWriteHandler(0xB,MMC4_WriteB);
	MP->SetWriteHandler(0xC,MMC4_WriteC);
	MP->SetWriteHandler(0xD,MMC4_WriteD);
	MP->SetWriteHandler(0xE,MMC4_WriteE);
	MP->SetWriteHandler(0xF,MMC4_WriteF);
	(MMC4.Sync = Sync)();
}

void	MMC4_Destroy (void)
{
}

int	MMC4_SaveMI (Ar128 MI, int x)
{
	MI[x++] = MMC4.LatchState[0];
	MI[x++] = MMC4.LatchState[1];
	MI[x++] = MMC4.Latch0[0];
	MI[x++] = MMC4.Latch0[1];
	MI[x++] = MMC4.Latch1[0];
	MI[x++] = MMC4.Latch1[1];
	return x;
}

int	MMC4_LoadMI (const Ar128 MI, int x)
{
	MMC4.LatchState[0]	= MI[x++];
	MMC4.LatchState[1]	= MI[x++];
	MMC4.Latch0[0]		= MI[x++];
	MMC4.Latch0[1]		= MI[x++];
	MMC4.Latch1[0]		= MI[x++];
	MMC4.Latch1[1]		= MI[x++];
	return x;
}

void	MMC4_SyncPRG (int AND, int OR)
{
	MP->SetPRG_ROM16(0x8,(MMC4.PRG & AND) | OR);
	MP->SetPRG_ROM16(0xC,(0xFF & AND) | OR);
}

void	MMC4_SyncCHR (void)
{
	if (MMC4.LatchState[0] == 0xFD)
		MP->SetCHR_ROM4(0,MMC4.Latch0[0]);
	else if (MMC4.LatchState[0] == 0xFE)
		MP->SetCHR_ROM4(0,MMC4.Latch0[1]);
	else	MP->DbgOut("WARNING: MMC4 latch 0 undefined!");

	if (MMC4.LatchState[1] == 0xFD)
		MP->SetCHR_ROM4(4,MMC4.Latch1[0]);
	else if (MMC4.LatchState[1] == 0xFE)
		MP->SetCHR_ROM4(4,MMC4.Latch1[1]);
	else	MP->DbgOut("WARNING: MMC4 latch 1 undefined!");
}

void	MMC4_SyncMirror (void)
{
	if (MMC4.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

int	__cdecl	MMC4_TileHandler (int Bank, int TileNum, int Index)
{
	if ((TileNum == 0xFD) || (TileNum == 0xFE))
	{
		MMC4.LatchState[Bank ? 1 : 0] = TileNum;
		MMC4_SyncCHR();
		return 1;
	}
	return 0;
}

void	__cdecl	MMC4_WriteA (int Bank, int Where, int What)
{
	MMC4.PRG = What;
	MMC4.Sync();
}
void	__cdecl	MMC4_WriteB (int Bank, int Where, int What)
{
	MMC4.Latch0[0] = What;
	MMC4.Sync();
}
void	__cdecl	MMC4_WriteC (int Bank, int Where, int What)
{
	MMC4.Latch0[1] = What;
	MMC4.Sync();
}
void	__cdecl	MMC4_WriteD (int Bank, int Where, int What)
{
	MMC4.Latch1[0] = What;
	MMC4.Sync();
}
void	__cdecl	MMC4_WriteE (int Bank, int Where, int What)
{
	MMC4.Latch1[1] = What;
	MMC4.Sync();
}
void	__cdecl	MMC4_WriteF (int Bank, int Where, int What)
{
	MMC4.Mirror = What;
	MMC4.Sync();
}