#include	"h_MMC6.h"

static	TMMC6	MMC6;

void	MMC6_Init (void (*Sync)(void))
{
	MMC6.PRG[0] = 0x00;	MMC6.PRG[1] = 0x01;

	MMC6.CHR[0] = 0x00;	MMC6.CHR[1] = 0x01;	MMC6.CHR[2] = 0x02;	MMC6.CHR[3] = 0x03;
	MMC6.CHR[4] = 0x04;	MMC6.CHR[5] = 0x05;	MMC6.CHR[6] = 0x06;	MMC6.CHR[7] = 0x07;

	MMC6.IRQenabled = MMC6.IRQcounter = MMC6.IRQlatch = 0;
	MMC6.Cmd = 0;
	MMC6.WriteWRAM = 0;
	MMC6.Mirror = 0;
	MMC6.ReadFunc_WRAM = MP->GetReadHandler(0x6);
	MP->SetReadHandler(0x6,MMC6_ReadWRAM);
	MP->SetReadHandler(0x7,MMC6_ReadWRAM);
	MMC6.WriteFunc_WRAM = MP->GetWriteHandler(0x6);
	MP->SetWriteHandler(0x6,MMC6_WriteWRAM);
	MP->SetWriteHandler(0x7,MMC6_WriteWRAM);
	MP->SetWriteHandler(0x8,MMC6_Write89);
	MP->SetWriteHandler(0x9,MMC6_Write89);
	MP->SetWriteHandler(0xA,MMC6_WriteAB);
	MP->SetWriteHandler(0xB,MMC6_WriteAB);
	MP->SetWriteHandler(0xC,MMC6_WriteCD);
	MP->SetWriteHandler(0xD,MMC6_WriteCD);
	MP->SetWriteHandler(0xE,MMC6_WriteEF);
	MP->SetWriteHandler(0xF,MMC6_WriteEF);

	MMC6.Sync = Sync;
	MMC6.Sync();
}

void	MMC6_Destroy (void)
{
	MMC6.Sync = NULL;
}

void	MMC6_SyncMirror (void)
{
	if (MMC6.Mirror & 1)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

int	MMC6_GetPRGBank (int Bank)
{
	u8 Banks[4];
	Banks[0] = MMC6.PRG[0];
	Banks[1] = MMC6.PRG[1];
	Banks[2] = 0x3E;
	Banks[3] = 0x3F;
	if (Bank & 0x1)
		return Banks[Bank];
	else	return Banks[Bank ^ ((MMC6.Cmd & 0x40) >> 5)];
}

int	MMC6_GetCHRBank (int Bank)
{
	return MMC6.CHR[Bank ^ ((MMC6.Cmd & 0x80) >> 5)];
}

void	MMC6_SyncPRG (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(8 | (x << 1),(MMC6_GetPRGBank(x) & AND) | OR);
}

void	MMC6_SyncCHR_ROM (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,(MMC6_GetCHRBank(x) & AND) | OR);
}

void	MMC6_SyncCHR_RAM (int AND, int OR)
{
	u8 x;
	for (x = 0; x < 8; x++)
		MP->SetCHR_RAM1(x,(MMC6_GetCHRBank(x) & AND) | OR);
}

int	MMC6_SaveMI (Ar128 MI, int x)
{
	u8 i;
			MI[x++] = MMC6.IRQcounter;
			MI[x++] = MMC6.IRQlatch;
			MI[x++] = MMC6.IRQenabled;
			MI[x++] = MMC6.Cmd;
for (i = 0; i < 2; i++) MI[x++] = MMC6.PRG[i];
for (i = 0; i < 4; i++)	MI[x++] = MMC6.CHR[i++];
for (i = 4; i < 8; i++)	MI[x++] = MMC6.CHR[i];
			MI[x++] = MMC6.WriteWRAM;
			MI[x++] = MMC6.Mirror;
	return x;
}

int	MMC6_LoadMI (const Ar128 MI, int x)
{
	u8 i;
			MMC6.IRQcounter	= MI[x++];
			MMC6.IRQlatch	= MI[x++];
			MMC6.IRQenabled	= MI[x++];
			MMC6.Cmd	= MI[x++];
for (i = 0; i < 2; i++) MMC6.PRG[i]	= MI[x++];
for (i = 0; i < 4; i++){MMC6.CHR[i++]	= MI[x++];
			MMC6.CHR[i]	= MMC6.CHR[i-1] | 1;}
for (i = 4; i < 8; i++)	MMC6.CHR[i]	= MI[x++];
			MMC6.WriteWRAM	= MI[x++];
			MMC6.Mirror	= MI[x++];
	MMC6.Sync();
	return x;
}

int	__cdecl	MMC6_ReadWRAM (int Bank, int Where)
{
	return MMC6.ReadFunc_WRAM(0x6,Where & 0x3FF);
}

void	__cdecl	MMC6_WriteWRAM (int Bank, int Where, int What)
{
	if (MMC6.WriteWRAM)
		MMC6.WriteFunc_WRAM(0x6,Where & 0x3FF,What);
}

void	__cdecl	MMC6_Write89 (int Bank, int Where, int What)
{
	if (Where & 1)
		switch (MMC6.Cmd & 0x7)
		{
		case 0:	MMC6.CHR[0] = (What & 0xFE) | 0;
			MMC6.CHR[1] = (What & 0xFE) | 1;break;
		case 1:	MMC6.CHR[2] = (What & 0xFE) | 0;
			MMC6.CHR[3] = (What & 0xFE) | 1;break;
		case 2:	MMC6.CHR[4] = What;		break;
		case 3:	MMC6.CHR[5] = What;		break;
		case 4:	MMC6.CHR[6] = What;		break;
		case 5:	MMC6.CHR[7] = What;		break;
		case 6:	MMC6.PRG[0] = What & 0x3F;	break;
		case 7:	MMC6.PRG[1] = What & 0x3F;	break;
		}
	else	MMC6.Cmd = What;
	MMC6.Sync();
}

void	__cdecl	MMC6_WriteAB (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC6.WriteWRAM = What;
	else	MMC6.Mirror = What;
	MMC6.Sync();
}

void	__cdecl	MMC6_WriteCD (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC6.IRQlatch = What;
	else	MMC6.IRQcounter = What;
}

void	__cdecl	MMC6_WriteEF (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC6.IRQenabled = 1;
	else	MMC6.IRQenabled = 0;
}

void	__cdecl	MMC6_HBlank (int Scanline, int Byte2001)
{
	if (Scanline > 239)
		return;
	if ((MMC6.IRQenabled) && (Byte2001 & 0x18))
	{
		if (MMC6.IRQcounter == 0)
		{
			MMC6.IRQcounter = MMC6.IRQlatch;
			MP->IRQ();
		}
		else	MMC6.IRQcounter--;
	}
}