#ifndef __MMC6_H__
#define __MMC6_H__

#include "..\interface.h"

typedef	struct	MMC6
{
	u8 IRQenabled, IRQcounter, IRQlatch;
	u8 Cmd;
	u8 PRG[2];
	u8 CHR[8];
	u8 WriteWRAM;
	u8 Mirror;
	PReadFunc ReadFunc_WRAM;
	PWriteFunc WriteFunc_WRAM;
	void	(*Sync)	(void);
}	TMMC6, *PMMC6;

void		MMC6_Init	(void (*)(void));
void		MMC6_Destroy	(void);
void		MMC6_SyncMirror	(void);
int		MMC6_GetPRGBank	(int);
int		MMC6_GetCHRBank	(int);
void		MMC6_SyncPRG	(int,int);
void		MMC6_SyncCHR_ROM(int,int);
void		MMC6_SyncCHR_RAM(int,int);
int		MMC6_SaveMI	(Ar128,int);
int		MMC6_LoadMI	(const Ar128,int);
int	__cdecl	MMC6_ReadWRAM	(int,int);
void	__cdecl	MMC6_WriteWRAM	(int,int,int);
void	__cdecl	MMC6_Write89	(int,int,int);
void	__cdecl	MMC6_WriteAB	(int,int,int);
void	__cdecl	MMC6_WriteCD	(int,int,int);
void	__cdecl	MMC6_WriteEF	(int,int,int);
void	__cdecl	MMC6_HBlank	(int,int);

#endif		/* __MMC6_H__ */