#include	"h_VS.h"

TVS	VS;

void	VS_Init (int IsHardReset)
{
	int dip;

	VS.CoinDelay = 0;
	VS.Coin = 0;			/* always clear coins */

	if (IsHardReset)
		VS.DipSwitch = 0;	/* only clear dipswitches on hard reset */

	if (!(MP->Flags & 0x0100))
		return;

	VS.Read = MP->GetReadHandler(0x4);
	MP->SetReadHandler(0x4,VS_Read);

	MP->AddMenuItem(MP->GetMenuRoot(),"&Left coin",		VS_MENUCOIN,0,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"&Right coin",	VS_MENUCOIN,1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MP->GetMenuRoot(),"&Service switch",	VS_MENUCOIN,2,-1,-1,MENU_NOCHECK);

	dip = MP->AddMenuItem(MP->GetMenuRoot(),"VS &Dip Switches",-1,-1,-1,-1,MENU_NOCHECK);

	MP->AddMenuItem(dip,"&0",VS_MENUDIP,0,-1,-1,((VS.DipSwitch >> 0) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&1",VS_MENUDIP,1,-1,-1,((VS.DipSwitch >> 1) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&2",VS_MENUDIP,2,-1,-1,((VS.DipSwitch >> 2) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&3",VS_MENUDIP,3,-1,-1,((VS.DipSwitch >> 3) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&4",VS_MENUDIP,4,-1,-1,((VS.DipSwitch >> 4) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&5",VS_MENUDIP,5,-1,-1,((VS.DipSwitch >> 5) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&6",VS_MENUDIP,6,-1,-1,((VS.DipSwitch >> 6) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
	MP->AddMenuItem(dip,"&7",VS_MENUDIP,7,-1,-1,((VS.DipSwitch >> 7) & 1) ? MENU_CHECKED : MENU_UNCHECKED);
}

int	VS_SaveMI (Ar128 MI)
{
	u8 x = 0;
	if (MP->Flags & 0x0100)
	{
		MI[x++] = VS.DipSwitch;
		MI[x++] = VS.Coin;
		MI[x++] = VS.CoinDelay;
	}
	return x;
}

int	VS_LoadMI (const Ar128 MI)
{
	u8 x = 0;
	if (MP->Flags & 0x0100)
	{
		VS.DipSwitch	= MI[x++];
		VS.Coin		= MI[x++];
		VS.CoinDelay	= MI[x++];
	}
	return x;
}

int	__cdecl	VS_Read (int Bank, int Where)
{
	int What = VS.Read(Bank,Where);
	if (Where == 0x016)
	{
		What &= 0x83;
		What |= VS.Coin;
		What |= ((VS.DipSwitch & 0x03) << 3);
	}
	else if (Where == 0x017)
	{
		What &= 0x03;
		What |= VS.DipSwitch & 0xFC;
	}
	return What;
}

void	__cdecl	VS_MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case VS_MENUCOIN:
		switch (Parm1)
		{
		case 0:	VS.Coin |= 0x20;	break;
		case 1:	VS.Coin |= 0x40;	break;
		case 2:	VS.Coin |= 0x04;	break;
		}
		VS.CoinDelay = 15;	break;
	case VS_MENUDIP:
		VS.DipSwitch ^= (1 << Parm1);	break;
	}
}

void	VS_CheckCoin (int Scanline)
{
	if ((Scanline == 0) && (VS.CoinDelay > 0))
	{
		VS.CoinDelay--;
		if (VS.CoinDelay == 0)
			VS.Coin = 0;
	}
}