#include	"..\DLL\d_NSF.h"
#include	"..\Hardware\Sound\s_FDS.h"
#include	"..\Hardware\Sound\s_FME07.h"
#include	"..\Hardware\Sound\s_MMC5.h"
#include	"..\Hardware\Sound\s_VRC6.h"
#include	"..\Hardware\Sound\s_VRC7.h"

static	struct
{
	u8 VRC7reg;
	u8 ExRAM[1024];
	PWriteFunc Write4;
	PReadFunc Read4;
}	NSF;

static	void	__cdecl	Write (int Bank,int Where,int What)
{
	if ((Where & 0xFF8) == 0xFF8)
		MP->SetPRG_ROM4(Where & 0xF,What);
}

static	int	__cdecl	FDS_Read (int Bank, int Where)
{
	if (Where < 0x18)
		return NSF.Read4(Bank,Where);
	return FDSsound_Read((Bank << 12) | Where);
}
static	void	__cdecl	FDS_Write (int Bank, int Where, int What)
{
	if (Where < 0x18)
		NSF.Write4(Bank,Where,What);
	FDSsound_Write((Bank << 12) | Where,What);
}

static	void	__cdecl	VRC6_Write (int Bank, int Where, int What)
{
	VRC6sound_Write((Bank << 12) | Where,What);
}

static	void	__cdecl	VRC7_Write (int Bank, int Where, int What)
{
	VRC7sound_Write((Bank << 12) | Where, What);
	VRC7sound_Write((Bank << 12) | Where, What);
}

static	int	__cdecl	MMC5_Read (int Bank, int Where)
{
	switch (Where & 0xF00)
	{
	case 0xC00:
	case 0xD00:
	case 0xE00:
	case 0xF00:	return NSF.ExRAM[Where & 0x3FF];	break;
	}
	return MP->GetReadHandler(0x8)(Bank,Where);
}
static	void	__cdecl	MMC5_Write (int Bank,int Where,int What)
{
	switch (Where & 0xF00)
	{
	case 0x000:	MMC5sound_Write((Bank << 12) | Where, What);	break;
	case 0xC00:
	case 0xD00:
	case 0xE00:
	case 0xF00:	Write(Bank,Where,What);
			NSF.ExRAM[Where & 0x3FF] = What;		break;
	}
}

static	void	__cdecl	FME07_Write (int Bank, int Where, int What)
{
	FME07sound_Write((Bank << 12) | Where,What);
}

static	void	__cdecl	MapperSnd (s16 *Buffer, int Len)
{
	if (MP->Flags & 0x01)		/* VRC6 */
		VRC6sound_Get(Buffer,Len);
	else if (MP->Flags & 0x02)	/* VRC7*/
		VRC7sound_Get(Buffer,Len);
	else if (MP->Flags & 0x04)	/* FDS */
		FDSsound_Get(Buffer,Len);
	else if (MP->Flags & 0x08)	/* MMC5 */
		MMC5sound_Get(Buffer,Len);
	else if (MP->Flags & 0x10)	/* Namco 106 */;
	else if (MP->Flags & 0x20)	/* Sunsoft FME-7 */
		FME07sound_Get(Buffer,Len);
}

static	void	__cdecl	UnloadMapper (void)
{
	if (MP->Flags & 0x01)		/* VRC6 */
		VRC6sound_Destroy();
	else if (MP->Flags & 0x02)	/* VRC7 */
		VRC7sound_Destroy();
	else if (MP->Flags & 0x04)	/* FDS */
		FDSsound_Destroy();
	else if (MP->Flags & 0x08)	/* MMC5 */
		MMC5sound_Destroy();
	else if (MP->Flags & 0x10)	/* Namco 106 */;
	else if (MP->Flags & 0x20)	/* Sunsoft FME-7 */
		FME07sound_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;

	NSF.Read4 = MP->GetReadHandler(0x4);
	NSF.Write4 = MP->GetWriteHandler(0x4);
	MP->SetWriteHandler(0x5,Write);
	MP->SetReadHandler(0x5,MP->GetReadHandler(0x8));
	MP->SetCHR_RAM8(0,0);

	if (MP->Flags & 0x01)		/* VRC6 */
	{
		VRC6sound_Init();
		MP->SetWriteHandler(0x9,VRC6_Write);
		MP->SetWriteHandler(0xA,VRC6_Write);
		MP->SetWriteHandler(0xB,VRC6_Write);
	}
	else if (MP->Flags & 0x02)	/* VRC7 */
	{
		VRC7sound_Init();
		NSF.VRC7reg = 0;
		MP->SetWriteHandler(0x9,VRC7_Write);
	}
	else if (MP->Flags & 0x04)	/* FDS */
	{
		FDSsound_Init();
		MP->SetReadHandler(0x4,FDS_Read);
		MP->SetWriteHandler(0x4,FDS_Write);
	}
	else if (MP->Flags & 0x08)	/* MMC5 */
	{
		MMC5sound_Init();
		MP->SetReadHandler(0x5,MMC5_Read);
		MP->SetWriteHandler(0x5,MMC5_Write);
	}
	else if (MP->Flags & 0x10)	/* Namco 106 */;
	else if (MP->Flags & 0x20)	/* Sunsoft FME-7 */
	{
		FME07sound_Init();
		MP->SetWriteHandler(0xC,FME07_Write);
		MP->SetWriteHandler(0xD,FME07_Write);
		MP->SetWriteHandler(0xE,FME07_Write);
		MP->SetWriteHandler(0xF,FME07_Write);
	}
}

CTMapperInfo	MapperInfo_NSF =
{
	"NSF",
	666,
	MS_Full,
	4096,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	MapperSnd,
	NULL
};