#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	struct
{
	u8 Regs[4];
	u8 Pos;
}	Mapper;

static	void	Sync (void)
{
	MMC3_SyncMirror();
	MMC3_SyncPRG(~Mapper.Regs[3] & 0x3F,Mapper.Regs[1]);
	MMC3_SyncCHR_ROM(0xFF >> ((~Mapper.Regs[2]) & 0xF),(Mapper.Regs[0]) | ((Mapper.Regs[2] & 0xF0) << 4));
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			x = MMC3_SaveMI(MI,x);
for (i = 0; i < 4; i++)	MI[x++] = Mapper.Regs[i];
			MI[x++] = Mapper.Pos;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			x = MMC3_LoadMI(MI,x);
for (i = 0; i < 4; i++)	Mapper.Regs[i]	= MI[x++];
			Mapper.Pos	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	if (Mapper.Regs[3] & 0x40)
		return;
	Mapper.Regs[Mapper.Pos++] = What;
	Mapper.Pos &= 0x03;
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	MMC3_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	MP->SetWriteHandler(0x6,Write);
	MP->SetWriteHandler(0x7,Write);

	for (x = 0; x < 4; x++)
		Mapper.Regs[x] = 0;
	Mapper.Pos = 0;

	MMC3_Init(Sync);
}

CTMapperInfo	MapperInfo_BMC_Super1Min1 =
{
	"BMC-Super1Min1",
	-1,
	MS_Full,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};