#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_74xx.h"

static	struct
{
	u8 Jumper;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetCHR_ROM8(0,_74xx.Addr & 0x07);
	if (_74xx.Addr & 0x80)
	{
		MP->SetPRG_ROM16(0x8,(_74xx.Addr & 0x70) >> 4);
		MP->SetPRG_ROM16(0xC,(_74xx.Addr & 0x70) >> 4);
	}
	else	MP->SetPRG_ROM32(0x8,(_74xx.Addr & 0x60) >> 5);
	if (_74xx.Addr & 0x08)
		MP->Mirror_H();
	else	MP->Mirror_V();
	if (_74xx.Addr & 0x100)
		for (x = 0x8; x < 0x10; x++)
		{
			MP->SetPRG_RAM4(x,x-8);
			memset(MP->GetPRG_Ptr4(x),Mapper.Jumper,0x1000);
		}
}

static	void	__cdecl	MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case 0:	switch (Parm1)
		{
		case 0:	Mapper.Jumper ^= 0x01;	break;
		case 1:	Mapper.Jumper ^= 0x02;	break;
		}	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	_74xx_SaveMI_A(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	_74xx_LoadMI_A(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	_74xx_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	_74xx_Init(Sync,IsHardReset,FALSE);
	MP->AddMenuItem(MP->GetMenuRoot(),"Jumper 0",0,0,-1,-1,(Mapper.Jumper & 0x01) ? 2 : 1);
	MP->AddMenuItem(MP->GetMenuRoot(),"Jumper 1",0,1,-1,-1,(Mapper.Jumper & 0x02) ? 2 : 1);
}

CTMapperInfo	MapperInfo_BMC_T3H53 =
{
	"BMC-T3H53",
	-1,
	MS_Full,
	16384,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	MenuClick
};