#include	"..\..\DLL\d_UNIF.h"
#include	<memory.h>

static	struct
{
	PReadFunc ReadWRAM;
	PWriteFunc WriteWRAM;
}	Mapper;

static	void	__cdecl	WriteROM (int Bank, int Where, int What)
{
}

static	int	__cdecl	ReadWRAM (int Bank, int Where)
{
	return Mapper.ReadWRAM(Bank,Where & 0x7FF);
}

static	void	__cdecl	WriteWRAM (int Bank, int Where, int What)
{
	Mapper.WriteWRAM(Bank,Where & 0x7FF,What);
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	MP = _MP;
	Mapper.ReadWRAM = MP->GetReadHandler(0x7);
	Mapper.WriteWRAM = MP->GetWriteHandler(0x7);
	MP->SetReadHandler(0x7,ReadWRAM);
	MP->SetWriteHandler(0x7,WriteWRAM);

	MP->SetPRG_ROM32(0x8,0);
	MP->SetPRG_ROM4(0x6,8);
	MP->SetPRG_RAM4(0x7,1);
	memcpy(MP->GetPRG_Ptr4(0x7),MP->GetPRG_Ptr4(0x6),0x800);
	memcpy(MP->GetPRG_Ptr4(0x7) + 0x800,MP->GetPRG_Ptr4(0x6),0x800);
	MP->SetPRG_RAM4(0x6,1);
	MP->SetWriteHandler(0x6,WriteROM);
	MP->SetPRG_RAM4(0x7,0);
	MP->SetCHR_ROM8(0,0);
	UNIF_SetMirroring(NULL);
}

CTMapperInfo	MapperInfo_BTL_MARIO1_MALEE2 =
{
	"BTL-MARIO1-MALEE2",
	-1,
	MS_Full,
	32768,
	InitMapper,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};