#include	"..\..\DLL\d_UNIF.h"
#include	"..\..\Hardware\h_MMC3.h"

static	struct
{
	PReadFunc	ReadRAM;
	PReadFunc	Read5;
	unsigned char	RAM[0x800];
}	Mapper;

static	void	Sync (void)
{
	MMC3_SyncPRG(0x3F,0);
	MMC3_SyncCHR_ROM(0xFF,0);
	MMC3_SyncMirror();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC3_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC3_LoadMI(MI,0);
}

static	void	__cdecl	UnloadMapper (void)
{
	UNIF_SaveSRAM();
	MMC3_Destroy();
}

static	int	__cdecl	Read (int Bank, int Where)
{
	unsigned char Data = Mapper.Read5(Bank,Where);
	if (Where & 0x800)
		return (Data & 0xFE) | (((~Where >> 8) | Where) & 1);
	else	return Data;
}

static	int	__cdecl	ReadRAM (int Bank, int Where)
{
	return Mapper.ReadRAM(Bank,Where) | Mapper.RAM[Where & 0x7FF];
}

static	void	__cdecl	Write5 (int Bank, int Where, int What)
{
	if (Where & 0x800)
		Mapper.RAM[Where & 0x7FF] = What;
}

static	void	__cdecl	Write89 (int Bank, int Where, int What)
{
	if (Where & 1)
		MMC3_Write89(Bank,Where,What);
	else
	{
		unsigned char LUT[8] = {0,3,1,5,6,7,2,4};
		MMC3_Write89(Bank,Where,(What & 0xC0) | LUT[What & 0x7]);
	}
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;
	MMC3_Init(Sync);
	MP->SetPRG_OB4(0x5);
	Mapper.ReadRAM = MP->GetReadHandler(0x0);
	MP->SetReadHandler(0x0,ReadRAM);
	MP->SetReadHandler(0x1,ReadRAM);
	Mapper.Read5 = MP->GetReadHandler(0x5);
	MP->SetReadHandler(0x5,Read);
	MP->SetWriteHandler(0x5,Write5);
	for (x = 0x8; x < 0xA; x++)
		MP->SetWriteHandler(x,Write89);	/* need to override writes to $8000 */
	memset(Mapper.RAM,0x00,0x800);
}

CTMapperInfo	MapperInfo_UNL_H2288 =
{
	"UNL-H2288",
	-1,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	MMC3_HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};