#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC5.h"

static	void	__cdecl	SaveMI (Ar128 MI)
{
	MMC5_SaveMI(MI,0);
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	MMC5_LoadMI(MI,0);
}

#define	MMC5_SELSRAM	200

static	void	__cdecl	MenuClick (int Command, int Parm1, int Parm2, int Parm3)
{
	switch (Command)
	{
	case MMC5_SELSRAM:
		MP->Set_SRAMSize(Parm2 << 10);
		MP->Load_SRAM();
		MMC5.WRAMsize = Parm1;
		MMC5_SyncPRG();			break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
	MMC5_Destroy();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	int MENU;

	MP = _MP;

	iNES_InitROM();

	MMC5.WRAMsize = MMC5WRAM_8KB_8KB;

	MMC5_Init();

	MENU = MP->AddMenuItem(MP->GetMenuRoot(),"Set WRAM size",-1,-1,-1,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"0/0",MMC5_SELSRAM,MMC5WRAM_0KB_0KB,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"8/0",MMC5_SELSRAM,MMC5WRAM_8KB_0KB,8,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"32/0",MMC5_SELSRAM,MMC5WRAM_32KB_0KB,32,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"* 0/8",MMC5_SELSRAM,MMC5WRAM_0KB_8KB,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"8/8",MMC5_SELSRAM,MMC5WRAM_8KB_8KB,8,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"* 32/8",MMC5_SELSRAM,MMC5WRAM_32KB_8KB,32,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"* 0/32",MMC5_SELSRAM,MMC5WRAM_0KB_32KB,0,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"* 8/32",MMC5_SELSRAM,MMC5WRAM_8KB_32KB,8,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"* 32/32",MMC5_SELSRAM,MMC5WRAM_32KB_32KB,32,-1,MENU_NOCHECK);
	MP->AddMenuItem(MENU,"* - normally unused",-1,-1,-1,-1,MENU_NOCHECK);
}

CTMapperInfo	MapperInfo_005  =
{
	"E*ROM (MMC5)",
	5,
	MS_Nearly,
	8192,
	InitMapper,
	UnloadMapper,
	MMC5_HBlank,
	MMC5_TileHandler,
	SaveMI,
	LoadMI,
	MMC5_MapperSnd,
	MenuClick
};