#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG[4];
	u8 Mirror;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 4; x++)
		MP->SetPRG_ROM8(0x8 | (x << 1),Mapper.PRG[x]);
	MP->SetCHR_RAM8(0,0);
	if (Mapper.Mirror)
		MP->Mirror_H();
	else	MP->Mirror_V();
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	MI[x++] = Mapper.PRG[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 4; i++)	Mapper.PRG[i]	= MI[x++];
			Mapper.Mirror	= MI[x++];
	Sync();
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	u8 PRGbank = (What & 0x3F) << 1;
	switch (Where)
	{
	case 0x000:
		if (What & 0x80)
		{
			Mapper.PRG[0] = PRGbank + 1;
			Mapper.PRG[1] = PRGbank + 0;
			Mapper.PRG[2] = PRGbank + 3;
			Mapper.PRG[3] = PRGbank + 2;
		}
		else
		{
			Mapper.PRG[0] = PRGbank + 0;
			Mapper.PRG[1] = PRGbank + 1;
			Mapper.PRG[2] = PRGbank + 2;
			Mapper.PRG[3] = PRGbank + 3;
		}
		Mapper.Mirror = What & 0x40;
		break;
	case 0x001:
		if (What & 0x80)
		{
			Mapper.PRG[0] = PRGbank + 1;
			Mapper.PRG[1] = PRGbank + 0;
		}
		else
		{
			Mapper.PRG[0] = PRGbank + 0;
			Mapper.PRG[1] = PRGbank + 1;
		}
		break;
	case 0x002:
		if (What & 0x80)
		{
			Mapper.PRG[0] = PRGbank + 1;
			Mapper.PRG[1] = PRGbank + 1;
			Mapper.PRG[2] = PRGbank + 1;
			Mapper.PRG[3] = PRGbank + 1;
		}
		else
		{
			Mapper.PRG[0] = PRGbank + 0;
			Mapper.PRG[1] = PRGbank + 0;
			Mapper.PRG[2] = PRGbank + 0;
			Mapper.PRG[3] = PRGbank + 0;
		}
		break;
	case 0x003:
		if (What & 0x80)
		{
			Mapper.PRG[2] = PRGbank + 1;
			Mapper.PRG[3] = PRGbank + 0;
		}
		else
		{
			Mapper.PRG[2] = PRGbank + 0;
			Mapper.PRG[3] = PRGbank + 1;
		}
		Mapper.Mirror = What & 0x40;
		break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;
	MP->SetWriteHandler(0x8,Write);

	iNES_InitROM();

	for (x = 0; x < 4; x++)
		Mapper.PRG[x] = x;
	Mapper.Mirror = 0;
	Sync();
}

CTMapperInfo	MapperInfo_015 =
{
	"100-in-1 Contra Function 16",
	15,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};