#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 PRG, CHR[8], Mirror;
	u8 IRQenabled;
	u16_n IRQcounter;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	MP->SetPRG_ROM16(0x8,Mapper.PRG);
	MP->SetPRG_ROM16(0xC,-1);
	for (x = 0; x < 8; x++)
	{
		if (MP->CHR_ROM_Size)
			MP->SetCHR_ROM1(x,Mapper.CHR[x]);
		else	MP->SetCHR_RAM1(x,Mapper.CHR[x] & 7);
	}
	switch (Mapper.Mirror)
	{
	case 0:	MP->Mirror_H();		break;
	case 1:	MP->Mirror_V();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
			MI[x++] = Mapper.IRQcounter.b0;
			MI[x++] = Mapper.IRQcounter.b1;
			MI[x++] = Mapper.IRQenabled;
			MI[x++] = Mapper.PRG;
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i];
			MI[x++] = Mapper.Mirror;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
			Mapper.IRQcounter.b0	= MI[x++];
			Mapper.IRQcounter.b1	= MI[x++];
			Mapper.IRQenabled	= MI[x++];
			Mapper.PRG		= MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i]		= MI[x++];
			Mapper.Mirror		= MI[x++];
	Sync();
}

static	void	__cdecl	HBlank (int Scanline,int Byte2001)
{
	if (Mapper.IRQenabled)
	{
		if (Mapper.IRQcounter.s0 < 114)
		{
			Mapper.IRQcounter.s0 = 0;
			MP->IRQ();
		}
		else	Mapper.IRQcounter.s0 -= 114;
	}
}

static	int	ReadRAM (void)
{
//	MP->DbgOut("Mapper 16 WRAM read!");
/*
== Call it in bulk ==
1. start transfer
2. address transfer
3. synchronize data
4. write data x8 in bulk
5. synchronize data
6. end transfer
*/
	return 0x00;
}

static	void	WriteRAM (int What)
{
//	MP->DbgOut("Mapper 16 WRAM write!");
/*
== Write it in bulk ==
1. start transfer
2. address transfer
3. synchronize data
4. data write x8 in bulk synchronous data
5. data synchronize
6. end transfer
-. Delay
*/
}

static	int	__cdecl	ReadWRAM (int Bank, int Where)
{
	if ((Where & 0xF) == 0)
		return ReadRAM();
	else	return (Bank << 4) | (Where >> 8);
}

static	void	__cdecl	Write (int Bank, int Where, int What)
{
	switch (Where & 0xF)
	{
	case 0x0:	Mapper.CHR[0] = What;		break;
	case 0x1:	Mapper.CHR[1] = What;		break;
	case 0x2:	Mapper.CHR[2] = What;		break;
	case 0x3:	Mapper.CHR[3] = What;		break;
	case 0x4:	Mapper.CHR[4] = What;		break;
	case 0x5:	Mapper.CHR[5] = What;		break;
	case 0x6:	Mapper.CHR[6] = What;		break;
	case 0x7:	Mapper.CHR[7] = What;		break;
	case 0x8:	Mapper.PRG = What;		break;
	case 0x9:	Mapper.Mirror = What & 0x3;	break;
	case 0xA:	Mapper.IRQenabled = What & 1;	break;
	case 0xB:	Mapper.IRQcounter.b0 = What;	break;
	case 0xC:	Mapper.IRQcounter.b1 = What;	break;
	case 0xD:	WriteRAM(What);			break;
	}
	Sync();
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	for (x = 0x6; x < 0x8; x++)
		MP->SetReadHandler(x,ReadWRAM);
	for (x = 0x6; x < 0x10; x++)
		MP->SetWriteHandler(x,Write);

	iNES_InitROM();
	Mapper.PRG = 0;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x] = x;
	Mapper.IRQenabled = 0;
	Mapper.IRQcounter.s0 = 0;
	Sync();
}

CTMapperInfo	MapperInfo_016 =
{
	"Bandai",
	16,
	MS_Partial,
	16384,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
