#include	"..\DLL\d_iNES.h"

static	struct
{
	u8_n PRG[3], CHR[8];
	u16 IRQcounter;
	u16_n IRQlatch;
	u8 IRQcontrol;
	u8 Mirror;
	u8 DisableSRAM;
	PReadFunc ReadSRAM;
	PWriteFunc WriteSRAM;
}	Mapper;

static	void	Sync (void)
{
	u8 x;
	for (x = 0; x < 3; x++)
		MP->SetPRG_ROM8(8 | (x << 1),Mapper.PRG[x].b0);

	MP->SetPRG_ROM8(0xE,0xFF);
	for (x = 0; x < 8; x++)
		MP->SetCHR_ROM1(x,Mapper.CHR[x].b0);
	switch (Mapper.Mirror)
	{
	case 0:	MP->Mirror_H();		break;
	case 1:	MP->Mirror_V();		break;
	case 2:	MP->Mirror_S0();	break;
	case 3:	MP->Mirror_S1();	break;
	}
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 3; i++)	MI[x++] = Mapper.PRG[i].b0;
for (i = 0; i < 8; i++)	MI[x++] = Mapper.CHR[i].b0;
	MI[x++] = (Mapper.IRQcounter >> 0) & 0xFF;
	MI[x++] = (Mapper.IRQcounter >> 8) & 0xFF;
	MI[x++] = Mapper.IRQlatch.b0;
	MI[x++] = Mapper.IRQlatch.b1;
	MI[x++] = Mapper.IRQcontrol;
	MI[x++] = Mapper.Mirror;
	MI[x++] = Mapper.DisableSRAM;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0, i;
for (i = 0; i < 3; i++)	Mapper.PRG[i].b0 = MI[x++];
for (i = 0; i < 8; i++)	Mapper.CHR[i].b0 = MI[x++];
	Mapper.IRQcounter	= MI[x++];
	Mapper.IRQcounter	|= (MI[x++] << 8);
	Mapper.IRQlatch.b0	= MI[x++];
	Mapper.IRQlatch.b1	= MI[x++];
	Mapper.IRQcontrol	= MI[x++];
	Mapper.Mirror		= MI[x++];
	Mapper.DisableSRAM	= MI[x++];
}

static	void	__cdecl	HBlank (int Scanline, int Byte2001)
{
	u16 IRQmask;
	if (Mapper.IRQcontrol & 0x8)
		IRQmask = 0xF;
	else if (Mapper.IRQcontrol & 0x4)
		IRQmask = 0xFF;
	else if (Mapper.IRQcontrol & 0x2)
		IRQmask = 0xFFF;
	else	IRQmask = 0xFFFF;
	if ((Mapper.IRQcontrol & 1) && ((Mapper.IRQcounter & IRQmask) < 114))
		MP->IRQ();
	Mapper.IRQcounter -= 114;
}

static	void	__cdecl	Write8 (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.PRG[0].n0 = What & 0xF;	break;
	case 1:	Mapper.PRG[0].n1 = What & 0xF;	break;
	case 2:	Mapper.PRG[1].n0 = What & 0xF;	break;
	case 3:	Mapper.PRG[1].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	Write9 (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.PRG[2].n0 = What & 0xF;	break;
	case 1:	Mapper.PRG[3].n1 = What & 0xF;	break;
	case 2:	Mapper.DisableSRAM = What & 1;	break;
	case 3:					break;
	}
	Sync();
}

static	void	__cdecl	WriteA (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[0].n0 = What & 0xF;	break;
	case 1:	Mapper.CHR[0].n1 = What & 0xF;	break;
	case 2:	Mapper.CHR[1].n0 = What & 0xF;	break;
	case 3:	Mapper.CHR[1].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteB (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[2].n0 = What & 0xF;	break;
	case 1:	Mapper.CHR[2].n1 = What & 0xF;	break;
	case 2:	Mapper.CHR[3].n0 = What & 0xF;	break;
	case 3:	Mapper.CHR[3].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteC (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[4].n0 = What & 0xF;	break;
	case 1:	Mapper.CHR[4].n1 = What & 0xF;	break;
	case 2:	Mapper.CHR[5].n0 = What & 0xF;	break;
	case 3:	Mapper.CHR[5].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteD (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.CHR[6].n0 = What & 0xF;	break;
	case 1:	Mapper.CHR[6].n1 = What & 0xF;	break;
	case 2:	Mapper.CHR[7].n0 = What & 0xF;	break;
	case 3:	Mapper.CHR[7].n1 = What & 0xF;	break;
	}
	Sync();
}

static	void	__cdecl	WriteE (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	Mapper.IRQlatch.n0 = What & 0xF;	break;
	case 1:	Mapper.IRQlatch.n1 = What & 0xF;	break;
	case 2:	Mapper.IRQlatch.n2 = What & 0xF;	break;
	case 3:	Mapper.IRQlatch.n3 = What & 0xF;	break;
	}
}


static	void	__cdecl	WriteF (int Bank, int Where, int What)
{
	switch (Where & 3)
	{
	case 0:	if (What & 1)
			Mapper.IRQcounter = Mapper.IRQlatch.s0;
		else	Mapper.IRQcounter = 0;	break;
	case 1:	Mapper.IRQcontrol = What & 0xF;	break;
	case 2:	Mapper.Mirror = What & 0x03;
		Sync();				break;
	case 3:					break;
	}
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;
	MP = _MP;

	MP->SetWriteHandler(0x8,Write8);
	MP->SetWriteHandler(0x9,Write9);
	MP->SetWriteHandler(0xA,WriteA);
	MP->SetWriteHandler(0xB,WriteB);
	MP->SetWriteHandler(0xC,WriteC);
	MP->SetWriteHandler(0xD,WriteD);
	MP->SetWriteHandler(0xE,WriteE);
	MP->SetWriteHandler(0xF,WriteF);

	iNES_InitROM();
	Mapper.PRG[0].b0 = 0x00;
	Mapper.PRG[1].b0 = 0x01;
	Mapper.PRG[2].b0 = 0xFE;
	for (x = 0; x < 8; x++)
		Mapper.CHR[x].b0 = x;
	Mapper.IRQcontrol = 0;
	Mapper.IRQcounter = Mapper.IRQlatch.s0 = 0;
	Mapper.Mirror = 0;
	Mapper.DisableSRAM = 1;
	Sync();
}

CTMapperInfo	MapperInfo_018 =
{
	"Jaleco SS8806",
	18,
	MS_Partial,
	8192,
	InitMapper,
	UnloadMapper,
	HBlank,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
