#include	"..\DLL\d_iNES.h"

static	struct
{
	u8 BNROM_PRG;
	u8 NINA_PRG;
	u8 NINA_CHR[2];
	u8 Mode;
	PWriteFunc Write7;
}	Mapper;

static	void	Sync (void)
{
	switch (Mapper.Mode)
	{
	case 0:	MP->SetPRG_ROM32(0x8,-1);
		MP->SetCHR_RAM8(0,0);
		break;
	case 1:	MP->SetPRG_RAM8(0x6,0);
		MP->SetPRG_ROM32(0x8,Mapper.NINA_PRG);
		MP->SetCHR_ROM4(0,Mapper.NINA_CHR[0]);
		MP->SetCHR_ROM4(4,Mapper.NINA_CHR[1]);
		break;
	case 2:	MP->SetPRG_ROM32(0x8,Mapper.BNROM_PRG);
		MP->SetCHR_RAM8(0,0);
		break;
	}
}

static	void	SetMode (int Mode)
{
	if (Mapper.Mode)
	{
		Sync();
		if (Mapper.Mode != Mode)
			MP->DbgOut("WTF? Mapper 34 attempting to use both NINA-01 and NES-BNROM behaviour!");
		return;
	}
	Mapper.Mode = Mode;
	Sync();
	if (Mode == 1)
		MP->DbgOut("Mapper 34 locked to NINA-01 subset");
	else if (Mode == 2)
		MP->DbgOut("Mapper 34 locked to NES-BNROM subset");
}

static	void	__cdecl	SaveMI (Ar128 MI)
{
	u8 x = 0;
	MI[x++] = Mapper.BNROM_PRG;
	MI[x++] = Mapper.NINA_PRG;
	MI[x++] = Mapper.NINA_CHR[0];
	MI[x++] = Mapper.NINA_CHR[1];
	MI[x++] = Mapper.Mode;
}

static	void	__cdecl	LoadMI (const Ar128 MI)
{
	u8 x = 0;
	Mapper.BNROM_PRG	= MI[x++];
	Mapper.NINA_PRG		= MI[x++];
	Mapper.NINA_CHR[0]	= MI[x++];
	Mapper.NINA_CHR[1]	= MI[x++];
	Mapper.Mode		= MI[x++];
	Sync();
}

static	void	__cdecl	WriteNINA (int Bank, int Where, int What)
{
	Mapper.Write7(Bank,Where,What);
	switch (Where)
	{
	case 0xFFD:	Mapper.NINA_PRG = What;
			SetMode(1);	break;
	case 0xFFE:	Mapper.NINA_CHR[0] = What;
			SetMode(1);	break;
	case 0xFFF:	Mapper.NINA_CHR[1] = What;
			SetMode(1);	break;
	}
}

static	void	__cdecl	WriteBNROM (int Bank, int Where, int What)
{
	Mapper.BNROM_PRG = What;
	SetMode(2);
}

static	void	__cdecl	UnloadMapper (void)
{
	iNES_UnloadROM();
}

static	void	__cdecl	InitMapper (const PMapperParam _MP, int IsHardReset)
{
	u8 x;

	MP = _MP;

	Mapper.Write7 = MP->GetWriteHandler(0x7);
	MP->SetWriteHandler(0x7,WriteNINA);

	for (x = 0x8; x < 0x10; x++)
		MP->SetWriteHandler(x,WriteBNROM);

	Mapper.BNROM_PRG = 0;
	Mapper.NINA_PRG = 0;
	Mapper.NINA_CHR[0] = 0;
	Mapper.NINA_CHR[1] = 1;
	Mapper.Mode = 0;
	Sync();

	iNES_InitROM();
}

CTMapperInfo	MapperInfo_034 =
{
	"BNROM/Nina-01",
	34,
	MS_Nearly,
	32768,
	InitMapper,
	UnloadMapper,
	NULL,
	NULL,
	SaveMI,
	LoadMI,
	NULL,
	NULL
};
